/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.app;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.app.CloudAppConfigurationNode;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appConfigService")
public final class CloudAppConfigurationService {
    @Autowired
    private CoordinatorRegistryCenter regCenter;

    public void add(CloudAppConfigurationPOJO appConfig) {
        this.regCenter.persist(CloudAppConfigurationNode.getRootNodePath(appConfig.getAppName()), YamlEngine.marshal((Object)appConfig));
    }

    public void update(CloudAppConfigurationPOJO appConfig) {
        this.regCenter.update(CloudAppConfigurationNode.getRootNodePath(appConfig.getAppName()), YamlEngine.marshal((Object)appConfig));
    }

    public Optional<CloudAppConfigurationPOJO> load(String appName) {
        String configContent = this.regCenter.get(CloudAppConfigurationNode.getRootNodePath(appName));
        return Strings.isNullOrEmpty((String)configContent) ? Optional.empty() : Optional.of((CloudAppConfigurationPOJO)YamlEngine.unmarshal((String)configContent, CloudAppConfigurationPOJO.class));
    }

    public Collection<CloudAppConfigurationPOJO> loadAll() {
        if (!this.regCenter.isExisted("/config/app")) {
            return Collections.emptyList();
        }
        List appNames = this.regCenter.getChildrenKeys("/config/app");
        ArrayList<CloudAppConfigurationPOJO> result = new ArrayList<CloudAppConfigurationPOJO>(appNames.size());
        for (String each : appNames) {
            Optional<CloudAppConfigurationPOJO> config = this.load(each);
            config.ifPresent(result::add);
        }
        return result;
    }

    public void remove(String appName) {
        this.regCenter.remove(CloudAppConfigurationNode.getRootNodePath(appName));
    }
}

