/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.job;

import org.apache.shardingsphere.elasticjob.cloud.ui.config.JobStateConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.job.DisableJobNode;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DisableJobService {
    private static final Logger log = LoggerFactory.getLogger(DisableJobService.class);
    @Autowired
    private CoordinatorRegistryCenter regCenter;
    @Autowired
    private JobStateConfiguration jobStateConfiguration;

    public void add(String jobName) {
        if (this.regCenter.getNumChildren("/state/disable/job") > this.jobStateConfiguration.getQueueSize()) {
            log.warn("Cannot add disable job, caused by read state queue size is larger than {}.", (Object)this.jobStateConfiguration.getQueueSize());
            return;
        }
        String disableJobNodePath = DisableJobNode.getDisableJobNodePath(jobName);
        if (!this.regCenter.isExisted(disableJobNodePath)) {
            this.regCenter.persist(disableJobNodePath, jobName);
        }
    }

    public void remove(String jobName) {
        this.regCenter.remove(DisableJobNode.getDisableJobNodePath(jobName));
    }

    public boolean isDisabled(String jobName) {
        return this.regCenter.isExisted(DisableJobNode.getDisableJobNodePath(jobName));
    }
}

