/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class CmpInstruction
extends TypedInstruction {
    private static Class[][] _mappings = new Class[][]{{Integer.TYPE, Long.TYPE}, {Byte.TYPE, Long.TYPE}, {Character.TYPE, Long.TYPE}, {Short.TYPE, Long.TYPE}, {Boolean.TYPE, Long.TYPE}, {Void.TYPE, Long.TYPE}, {Object.class, Long.TYPE}};

    CmpInstruction(Code owner) {
        super(owner);
    }

    CmpInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    @Override
    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public int getStackChange() {
        switch (this.getOpcode()) {
            case 148: 
            case 151: 
            case 152: {
                return -3;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public String getTypeName() {
        switch (this.getOpcode()) {
            case 148: {
                return Long.TYPE.getName();
            }
            case 149: 
            case 150: {
                return Float.TYPE.getName();
            }
            case 151: 
            case 152: {
                return Double.TYPE.getName();
            }
        }
        return null;
    }

    @Override
    public TypedInstruction setType(String type) {
        if ((type = this.mapType(type, _mappings, true)) == null) {
            return (TypedInstruction)this.setOpcode(0);
        }
        int opcode = this.getOpcode();
        switch (type.charAt(0)) {
            case 'l': {
                return (TypedInstruction)this.setOpcode(148);
            }
            case 'f': {
                if (opcode == 149 || opcode == 151) {
                    return (TypedInstruction)this.setOpcode(149);
                }
                return (TypedInstruction)this.setOpcode(150);
            }
            case 'd': {
                if (opcode == 149 || opcode == 151) {
                    return (TypedInstruction)this.setOpcode(151);
                }
                return (TypedInstruction)this.setOpcode(152);
            }
        }
        throw new IllegalStateException();
    }

    public int getNaNValue() {
        switch (this.getOpcode()) {
            case 149: 
            case 151: {
                return -1;
            }
            case 150: 
            case 152: {
                return 1;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmpInstruction setNaNValue(int nan) {
        switch (this.getOpcode()) {
            case 149: 
            case 150: {
                if (nan == 1) {
                    this.setOpcode(150);
                } else {
                    if (nan != -1) throw new IllegalArgumentException("Invalid nan for type");
                    this.setOpcode(149);
                }
            }
            case 151: 
            case 152: {
                if (nan == 1) {
                    this.setOpcode(152);
                    break;
                }
                if (nan != -1) throw new IllegalArgumentException("Invalid nan for type");
                this.setOpcode(151);
                break;
            }
        }
        if (nan == 0) return this;
        throw new IllegalArgumentException("Invalid nan for type");
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterCmpInstruction(this);
        visit.exitCmpInstruction(this);
    }
}

