/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantMethodHandle;
import org.aspectj.apache.bcel.classfile.ConstantPool;

public final class BootstrapMethods
extends Attribute {
    private boolean isInPackedState = false;
    private byte[] data;
    private int numBootstrapMethods;
    private BootstrapMethod[] bootstrapMethods;

    public BootstrapMethods(BootstrapMethods bootstrapMethods) {
        this(bootstrapMethods.getNameIndex(), bootstrapMethods.getLength(), bootstrapMethods.getBootstrapMethods(), bootstrapMethods.getConstantPool());
    }

    public BootstrapMethods(int n, int n2, BootstrapMethod[] bootstrapMethodArray, ConstantPool constantPool) {
        super((byte)19, n, n2, constantPool);
        this.setBootstrapMethods(bootstrapMethodArray);
        this.isInPackedState = false;
    }

    public final void setBootstrapMethods(BootstrapMethod[] bootstrapMethodArray) {
        this.data = null;
        this.isInPackedState = false;
        this.bootstrapMethods = bootstrapMethodArray;
        this.numBootstrapMethods = bootstrapMethodArray == null ? 0 : bootstrapMethodArray.length;
    }

    BootstrapMethods(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (BootstrapMethod[])null, constantPool);
        this.data = new byte[n2];
        dataInputStream.readFully(this.data);
        this.isInPackedState = true;
    }

    private void unpack() {
        if (this.isInPackedState) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.numBootstrapMethods = dataInputStream.readUnsignedShort();
                this.bootstrapMethods = new BootstrapMethod[this.numBootstrapMethods];
                for (int i = 0; i < this.numBootstrapMethods; ++i) {
                    this.bootstrapMethods[i] = new BootstrapMethod(dataInputStream);
                }
                dataInputStream.close();
                this.data = null;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unpacking of LineNumberTable attribute failed");
            }
            this.isInPackedState = false;
        }
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        this.unpack();
        classVisitor.visitBootstrapMethods(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.isInPackedState) {
            dataOutputStream.write(this.data);
        } else {
            int n = this.bootstrapMethods.length;
            dataOutputStream.writeShort(n);
            for (int i = 0; i < n; ++i) {
                this.bootstrapMethods[i].dump(dataOutputStream);
            }
        }
    }

    public final BootstrapMethod[] getBootstrapMethods() {
        this.unpack();
        return this.bootstrapMethods;
    }

    @Override
    public final String toString() {
        this.unpack();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.numBootstrapMethods; ++i) {
            BootstrapMethod bootstrapMethod = this.bootstrapMethods[i];
            stringBuffer2.append("BootstrapMethod[").append(i).append("]:");
            int n = bootstrapMethod.getBootstrapMethodRef();
            ConstantMethodHandle constantMethodHandle = (ConstantMethodHandle)this.getConstantPool().getConstant(n);
            stringBuffer2.append("#" + n + ":");
            stringBuffer2.append(ConstantMethodHandle.kindToString(constantMethodHandle.getReferenceKind()));
            stringBuffer2.append(" ").append(this.getConstantPool().getConstant(constantMethodHandle.getReferenceIndex()));
            int[] nArray = bootstrapMethod.getBootstrapArguments();
            stringBuffer2.append(" argcount:").append(nArray == null ? 0 : nArray.length).append(" ");
            if (nArray != null) {
                for (int j = 0; j < nArray.length; ++j) {
                    stringBuffer2.append(nArray[j]).append("(").append(this.getConstantPool().getConstant(nArray[j])).append(") ");
                }
            }
            if (i < this.numBootstrapMethods - 1) {
                stringBuffer2.append(", ");
            }
            if (stringBuffer2.length() <= 72) continue;
            stringBuffer2.append('\n');
            stringBuffer.append(stringBuffer2);
            stringBuffer2.setLength(0);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    public final int getNumBootstrapMethods() {
        this.unpack();
        return this.bootstrapMethods.length;
    }

    public static class BootstrapMethod {
        private int bootstrapMethodRef;
        private int[] bootstrapArguments;

        BootstrapMethod(DataInputStream dataInputStream) throws IOException {
            this(dataInputStream.readUnsignedShort(), BootstrapMethod.readBootstrapArguments(dataInputStream));
        }

        private static int[] readBootstrapArguments(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readUnsignedShort();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dataInputStream.readUnsignedShort();
            }
            return nArray;
        }

        public BootstrapMethod(int n, int[] nArray) {
            this.bootstrapMethodRef = n;
            this.bootstrapArguments = nArray;
        }

        public int getBootstrapMethodRef() {
            return this.bootstrapMethodRef;
        }

        public int[] getBootstrapArguments() {
            return this.bootstrapArguments;
        }

        public final void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.bootstrapMethodRef);
            int n = this.bootstrapArguments.length;
            dataOutputStream.writeShort(n);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeShort(this.bootstrapArguments[i]);
            }
        }

        public final int getLength() {
            return 4 + 2 * this.bootstrapArguments.length;
        }
    }
}

