/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantPool;

public final class ConstantClass
extends Constant {
    private int nameIndex;

    ConstantClass(DataInputStream dataInputStream) throws IOException {
        super((byte)7);
        this.nameIndex = dataInputStream.readUnsignedShort();
    }

    public ConstantClass(int n) {
        super((byte)7);
        this.nameIndex = n;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantClass(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.nameIndex);
    }

    public final int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public Integer getValue() {
        return this.nameIndex;
    }

    public String getClassname(ConstantPool constantPool) {
        return constantPool.getConstantUtf8(this.nameIndex).getValue();
    }

    @Override
    public final String toString() {
        return super.toString() + "(name_index = " + this.nameIndex + ")";
    }
}

