/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LocalVariable;

public class LocalVariableTable
extends Attribute {
    private boolean isInPackedState = false;
    private byte[] data;
    private int localVariableTableLength;
    private LocalVariable[] localVariableTable;

    public LocalVariableTable(LocalVariableTable localVariableTable) {
        this(localVariableTable.getNameIndex(), localVariableTable.getLength(), localVariableTable.getLocalVariableTable(), localVariableTable.getConstantPool());
    }

    public LocalVariableTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)5, n, n2, constantPool);
        this.setLocalVariableTable(localVariableArray);
    }

    LocalVariableTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        super((byte)5, n, n2, constantPool);
        this.data = new byte[n2];
        dataInputStream.readFully(this.data);
        this.isInPackedState = true;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        this.unpack();
        classVisitor.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.isInPackedState) {
            dataOutputStream.write(this.data);
        } else {
            dataOutputStream.writeShort(this.localVariableTableLength);
            for (int i = 0; i < this.localVariableTableLength; ++i) {
                this.localVariableTable[i].dump(dataOutputStream);
            }
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        this.unpack();
        return this.localVariableTable;
    }

    public final LocalVariable getLocalVariable(int n) {
        this.unpack();
        for (int i = 0; i < this.localVariableTableLength; ++i) {
            if (this.localVariableTable[i] == null || this.localVariableTable[i].getIndex() != n) continue;
            return this.localVariableTable[i];
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.data = null;
        this.isInPackedState = false;
        this.localVariableTable = localVariableArray;
        this.localVariableTableLength = localVariableArray == null ? 0 : localVariableArray.length;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        this.unpack();
        for (int i = 0; i < this.localVariableTableLength; ++i) {
            stringBuffer.append(this.localVariableTable[i].toString());
            if (i >= this.localVariableTableLength - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public final int getTableLength() {
        this.unpack();
        return this.localVariableTableLength;
    }

    private void unpack() {
        if (!this.isInPackedState) {
            return;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.localVariableTableLength = dataInputStream.readUnsignedShort();
            this.localVariableTable = new LocalVariable[this.localVariableTableLength];
            for (int i = 0; i < this.localVariableTableLength; ++i) {
                this.localVariableTable[i] = new LocalVariable(dataInputStream, this.cpool);
            }
            dataInputStream.close();
            this.data = null;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unpacking of LocalVariableTable attribute failed");
        }
        this.isInPackedState = false;
    }
}

