/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;

public class MethodParameters
extends Attribute {
    public static final int[] NO_PARAMETER_NAME_INDEXES = new int[0];
    public static final int[] NO_PARAMETER_ACCESS_FLAGS = new int[0];
    public static final int ACCESS_FLAGS_FINAL = 16;
    public static final int ACCESS_FLAGS_SYNTHETIC = 4096;
    public static final int ACCESS_FLAGS_MANDATED = 32768;
    private boolean isInPackedState = false;
    private byte[] data;
    private int[] names;
    private int[] accessFlags;

    public MethodParameters(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        super((byte)22, n, n2, constantPool);
        this.data = new byte[n2];
        dataInputStream.readFully(this.data, 0, n2);
        this.isInPackedState = true;
    }

    private void ensureInflated() {
        if (this.names != null) {
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.data));
            int n = dataInputStream.readUnsignedByte();
            if (n == 0) {
                this.names = NO_PARAMETER_NAME_INDEXES;
                this.accessFlags = NO_PARAMETER_ACCESS_FLAGS;
            } else {
                this.names = new int[n];
                this.accessFlags = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.names[i] = dataInputStream.readUnsignedShort();
                    this.accessFlags[i] = dataInputStream.readUnsignedShort();
                }
            }
            this.isInPackedState = false;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unabled to inflate type annotation data, badly formed?");
        }
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.isInPackedState) {
            dataOutputStream.write(this.data);
        } else {
            dataOutputStream.writeByte(this.names.length);
            for (int i = 0; i < this.names.length; ++i) {
                dataOutputStream.writeShort(this.names[i]);
                dataOutputStream.writeShort(this.accessFlags[i]);
            }
        }
    }

    public int getParametersCount() {
        this.ensureInflated();
        return this.names.length;
    }

    public String getParameterName(int n) {
        this.ensureInflated();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.names[n], (byte)1);
        return constantUtf8.getValue();
    }

    public int getAccessFlags(int n) {
        this.ensureInflated();
        return this.accessFlags[n];
    }

    public boolean isFinal(int n) {
        return (this.getAccessFlags(n) & 0x10) != 0;
    }

    public boolean isSynthetic(int n) {
        return (this.getAccessFlags(n) & 0x1000) != 0;
    }

    public boolean isMandated(int n) {
        return (this.getAccessFlags(n) & 0x8000) != 0;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitMethodParameters(this);
    }
}

