/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionConstants;

public class InstructionLV
extends Instruction {
    protected int lvar = -1;

    public InstructionLV(short s, int n) {
        super(s);
        this.lvar = n;
    }

    public InstructionLV(short s) {
        super(s);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.lvar == -1) {
            dataOutputStream.writeByte(this.opcode);
        } else if (this.lvar < 4) {
            if (this.opcode == 25) {
                dataOutputStream.writeByte(42 + this.lvar);
            } else if (this.opcode == 58) {
                dataOutputStream.writeByte(75 + this.lvar);
            } else if (this.opcode == 21) {
                dataOutputStream.writeByte(26 + this.lvar);
            } else if (this.opcode == 54) {
                dataOutputStream.writeByte(59 + this.lvar);
            } else if (this.opcode == 24) {
                dataOutputStream.writeByte(38 + this.lvar);
            } else if (this.opcode == 57) {
                dataOutputStream.writeByte(71 + this.lvar);
            } else if (this.opcode == 23) {
                dataOutputStream.writeByte(34 + this.lvar);
            } else if (this.opcode == 56) {
                dataOutputStream.writeByte(67 + this.lvar);
            } else if (this.opcode == 22) {
                dataOutputStream.writeByte(30 + this.lvar);
            } else if (this.opcode == 55) {
                dataOutputStream.writeByte(63 + this.lvar);
            } else {
                if (this.wide()) {
                    dataOutputStream.writeByte(196);
                }
                dataOutputStream.writeByte(this.opcode);
                if (this.wide()) {
                    dataOutputStream.writeShort(this.lvar);
                } else {
                    dataOutputStream.writeByte(this.lvar);
                }
            }
        } else {
            if (this.wide()) {
                dataOutputStream.writeByte(196);
            }
            dataOutputStream.writeByte(this.opcode);
            if (this.wide()) {
                dataOutputStream.writeShort(this.lvar);
            } else {
                dataOutputStream.writeByte(this.lvar);
            }
        }
    }

    @Override
    public String toString(boolean bl) {
        if (this.opcode >= 26 && this.opcode <= 45 || this.opcode >= 59 && this.opcode <= 78) {
            return super.toString(bl);
        }
        return super.toString(bl) + (this.lvar != -1 && this.lvar < 4 ? "_" : " ") + this.lvar;
    }

    @Override
    public boolean isALOAD() {
        return this.opcode == 25 || this.opcode >= 42 && this.opcode <= 45;
    }

    @Override
    public boolean isASTORE() {
        return this.opcode == 58 || this.opcode >= 75 && this.opcode <= 78;
    }

    public int getBaseOpcode() {
        if (this.opcode >= 21 && this.opcode <= 25 || this.opcode >= 54 && this.opcode <= 58) {
            return this.opcode;
        }
        if (this.opcode >= 26 && this.opcode <= 45) {
            int n = this.opcode - 26;
            n -= n % 4;
            return (n /= 4) + 21;
        }
        int n = this.opcode - 59;
        n -= n % 4;
        return (n /= 4) + 54;
    }

    @Override
    public final int getIndex() {
        if (this.lvar != -1) {
            return this.lvar;
        }
        if (this.opcode >= 26 && this.opcode <= 45) {
            return (this.opcode - 26) % 4;
        }
        if (this.opcode >= 59 && this.opcode <= 78) {
            return (this.opcode - 59) % 4;
        }
        return -1;
    }

    @Override
    public void setIndex(int n) {
        if (this.getIndex() != n) {
            if (this.opcode >= 26 && this.opcode <= 45) {
                this.opcode = (short)(21 + (this.opcode - 26) / 4);
            } else if (this.opcode >= 59 && this.opcode <= 78) {
                this.opcode = (short)(54 + (this.opcode - 59) / 4);
            }
            this.lvar = n;
        }
    }

    public boolean canSetIndex() {
        return true;
    }

    public InstructionLV setIndexAndCopyIfNecessary(int n) {
        if (this.canSetIndex()) {
            this.setIndex(n);
            return this;
        }
        if (this.getIndex() == n) {
            return this;
        }
        InstructionLV instructionLV = null;
        int n2 = this.getBaseOpcode();
        instructionLV = n < 4 ? (this.isStoreInstruction() ? (InstructionLV)InstructionConstants.INSTRUCTIONS[(n2 - 54) * 4 + 59 + n] : (InstructionLV)InstructionConstants.INSTRUCTIONS[(n2 - 21) * 4 + 26 + n]) : new InstructionLV((short)n2, n);
        return instructionLV;
    }

    @Override
    public int getLength() {
        byte by = Constants.iLen[this.opcode];
        if (this.lvar == -1) {
            return by;
        }
        if (this.lvar < 4) {
            if (this.opcode == 25 || this.opcode == 58) {
                return 1;
            }
            if (this.opcode == 21 || this.opcode == 54) {
                return 1;
            }
            if (this.opcode == 24 || this.opcode == 57) {
                return 1;
            }
            if (this.opcode == 23 || this.opcode == 56) {
                return 1;
            }
            if (this.opcode == 22 || this.opcode == 55) {
                return 1;
            }
            if (this.wide()) {
                return by + 2;
            }
            return by;
        }
        if (this.wide()) {
            return by + 2;
        }
        return by;
    }

    private final boolean wide() {
        return this.lvar > 255;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof InstructionLV)) {
            return false;
        }
        InstructionLV instructionLV = (InstructionLV)object;
        return instructionLV.opcode == this.opcode && instructionLV.lvar == this.lvar;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37 + this.lvar;
    }
}

