/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.ExceptionConstants;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.InstructionCP;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Type;

public class MULTIANEWARRAY
extends InstructionCP {
    private short dimensions;

    public MULTIANEWARRAY(int n, short s) {
        super((short)197, n);
        this.dimensions = s;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
        dataOutputStream.writeByte(this.dimensions);
    }

    public final short getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index + " " + this.dimensions;
    }

    @Override
    public String toString(ConstantPool constantPool) {
        return super.toString(constantPool) + " " + this.dimensions;
    }

    @Override
    public int consumeStack(ConstantPool constantPool) {
        return this.dimensions;
    }

    public Class[] getExceptions() {
        Class[] classArray = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, classArray, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length + 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return classArray;
    }

    @Override
    public ObjectType getLoadClassType(ConstantPool constantPool) {
        Type type = this.getType(constantPool);
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getBasicType();
        }
        return type instanceof ObjectType ? (ObjectType)type : null;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MULTIANEWARRAY)) {
            return false;
        }
        MULTIANEWARRAY mULTIANEWARRAY = (MULTIANEWARRAY)object;
        return mULTIANEWARRAY.opcode == this.opcode && mULTIANEWARRAY.index == this.index && mULTIANEWARRAY.dimensions == this.dimensions;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37 + this.index * (this.dimensions + 17);
    }
}

