/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.apache.bcel.ConstantsInitializer;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.ReferenceType;

public abstract class Type {
    protected byte type;
    protected String signature;
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType OBJECT_ARRAY = new ObjectType("java.lang.Object[]");
    public static final ObjectType STRING_ARRAY = new ObjectType("java.lang.String[]");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final ObjectType STRINGBUILDER = new ObjectType("java.lang.StringBuilder");
    public static final ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final ObjectType CLASS = new ObjectType("java.lang.Class");
    public static final ObjectType INTEGER = new ObjectType("java.lang.Integer");
    public static final ObjectType EXCEPTION = new ObjectType("java.lang.Exception");
    public static final ObjectType LIST = new ObjectType("java.util.List");
    public static final ObjectType ITERATOR = new ObjectType("java.util.Iterator");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType(){};
    public static final Type UNKNOWN = new Type(15, "<unknown object>"){};
    public static final Type[] STRINGARRAY1 = new Type[]{STRING};
    public static final Type[] STRINGARRAY2 = new Type[]{STRING, STRING};
    public static final Type[] STRINGARRAY3 = new Type[]{STRING, STRING, STRING};
    public static final Type[] STRINGARRAY4 = new Type[]{STRING, STRING, STRING, STRING};
    public static final Type[] STRINGARRAY5 = new Type[]{STRING, STRING, STRING, STRING, STRING};
    public static final Type[] STRINGARRAY6 = new Type[]{STRING, STRING, STRING, STRING, STRING, STRING};
    public static final Type[] STRINGARRAY7 = new Type[]{STRING, STRING, STRING, STRING, STRING, STRING, STRING};
    private static Map<String, Type> commonTypes = new HashMap<String, Type>();

    protected Type(byte by, String string) {
        this.type = by;
        this.signature = string;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static final Type getType(String string) {
        Type type = commonTypes.get(string);
        if (type != null) {
            return type;
        }
        byte by = Utility.typeOfSignature(string);
        if (by <= 12) {
            return BasicType.getType(by);
        }
        if (by == 13) {
            int n = 0;
            while (string.charAt(++n) == '[') {
            }
            Type type2 = Type.getType(string.substring(n));
            return new ArrayType(type2, n);
        }
        int n = string.indexOf(60);
        int n2 = string.indexOf(59);
        String string2 = null;
        if (n == -1 || n > n2) {
            string2 = string.substring(1, n2).replace('/', '.');
        } else {
            boolean bl = false;
            int n3 = n;
            int n4 = 0;
            block6: while (!bl) {
                switch (string.charAt(n3++)) {
                    case '<': {
                        ++n4;
                        continue block6;
                    }
                    case '>': {
                        --n4;
                        continue block6;
                    }
                    case ';': {
                        if (n4 != 0) continue block6;
                        bl = true;
                        continue block6;
                    }
                }
            }
            n2 = n3 - 1;
            string2 = string.substring(1, n).replace('/', '.');
        }
        return new ObjectType(string2);
    }

    public static final TypeHolder getTypeInternal(String string) throws StringIndexOutOfBoundsException {
        byte by = Utility.typeOfSignature(string);
        if (by <= 12) {
            return new TypeHolder(BasicType.getType(by), 1);
        }
        if (by == 13) {
            int n = 0;
            while (string.charAt(++n) == '[') {
            }
            TypeHolder typeHolder = Type.getTypeInternal(string.substring(n));
            return new TypeHolder(new ArrayType(typeHolder.getType(), n), n + typeHolder.getConsumed());
        }
        int n = string.indexOf(59);
        if (n < 0) {
            throw new ClassFormatException("Invalid signature: " + string);
        }
        int n2 = string.indexOf(60);
        String string2 = null;
        if (n2 == -1 || n2 > n) {
            string2 = string.substring(1, n).replace('/', '.');
        } else {
            boolean bl = false;
            int n3 = n2;
            int n4 = 0;
            block6: while (!bl) {
                switch (string.charAt(n3++)) {
                    case '<': {
                        ++n4;
                        continue block6;
                    }
                    case '>': {
                        --n4;
                        continue block6;
                    }
                    case ';': {
                        if (n4 != 0) continue block6;
                        bl = true;
                        continue block6;
                    }
                }
            }
            n = n3 - 1;
            string2 = string.substring(1, n2).replace('/', '.');
        }
        return new TypeHolder(new ObjectType(string2), n + 1);
    }

    public static Type getReturnType(String string) {
        try {
            int n = string.lastIndexOf(41) + 1;
            return Type.getType(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
    }

    public static Type[] getArgumentTypes(String string) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n = 1;
            while (string.charAt(n) != ')') {
                TypeHolder typeHolder = Type.getTypeInternal(string.substring(n));
                arrayList.add(typeHolder.getType());
                n += typeHolder.getConsumed();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        Type[] typeArray = new Type[arrayList.size()];
        arrayList.toArray(typeArray);
        return typeArray;
    }

    public static int getArgumentSizes(String string) {
        int n = 0;
        if (string.charAt(0) != '(') {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        int n2 = 1;
        try {
            while (string.charAt(n2) != ')') {
                int n3;
                byte by = Utility.typeOfSignature(string.charAt(n2));
                if (by <= 12) {
                    n += BasicType.getType(by).getSize();
                    ++n2;
                    continue;
                }
                if (by == 13) {
                    n3 = 0;
                    while (string.charAt(++n3 + n2) == '[') {
                    }
                    TypeHolder typeHolder = Type.getTypeInternal(string.substring(n3 + n2));
                    ++n;
                    n2 += n3 + typeHolder.getConsumed();
                    continue;
                }
                n3 = string.indexOf(59, n2);
                int n4 = string.indexOf(60, n2);
                if (n4 != -1 && n4 <= n3) {
                    boolean bl = false;
                    int n5 = n4;
                    int n6 = 0;
                    block9: while (!bl) {
                        switch (string.charAt(n5++)) {
                            case '<': {
                                ++n6;
                                continue block9;
                            }
                            case '>': {
                                --n6;
                                continue block9;
                            }
                            case ';': {
                                if (n6 != 0) continue block9;
                                bl = true;
                                continue block9;
                            }
                        }
                    }
                    n3 = n5 - 1;
                }
                ++n;
                n2 = n3 + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        return n;
    }

    public static int getTypeSize(String string) {
        byte by = Utility.typeOfSignature(string.charAt(0));
        if (by <= 12) {
            return BasicType.getType(by).getSize();
        }
        if (by == 13) {
            return 1;
        }
        return 1;
    }

    public static Type getType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (clazz.isArray()) {
            return Type.getType(clazz.getName());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT;
            }
            if (clazz == Void.TYPE) {
                return VOID;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (clazz == Byte.TYPE) {
                return BYTE;
            }
            if (clazz == Short.TYPE) {
                return SHORT;
            }
            if (clazz == Byte.TYPE) {
                return BYTE;
            }
            if (clazz == Long.TYPE) {
                return LONG;
            }
            if (clazz == Character.TYPE) {
                return CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + clazz);
        }
        return new ObjectType(clazz.getName());
    }

    public static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(Type.getType(classArray[i]).getSignature());
        }
        stringBuffer.append(")");
        stringBuffer.append(Type.getType(method.getReturnType()).getSignature());
        return stringBuffer.toString();
    }

    public static String getSignature(Constructor<?> constructor) {
        StringBuffer stringBuffer = new StringBuffer("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(Type.getType(classArray[i]).getSignature());
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    static {
        commonTypes.put(STRING.getSignature(), STRING);
        commonTypes.put(THROWABLE.getSignature(), THROWABLE);
        commonTypes.put(VOID.getSignature(), VOID);
        commonTypes.put(BOOLEAN.getSignature(), BOOLEAN);
        commonTypes.put(BYTE.getSignature(), BYTE);
        commonTypes.put(SHORT.getSignature(), SHORT);
        commonTypes.put(CHAR.getSignature(), CHAR);
        commonTypes.put(INT.getSignature(), INT);
        commonTypes.put(LONG.getSignature(), LONG);
        commonTypes.put(DOUBLE.getSignature(), DOUBLE);
        commonTypes.put(FLOAT.getSignature(), FLOAT);
        commonTypes.put(CLASS.getSignature(), CLASS);
        commonTypes.put(OBJECT.getSignature(), OBJECT);
        commonTypes.put(STRING_ARRAY.getSignature(), STRING_ARRAY);
        commonTypes.put(OBJECT_ARRAY.getSignature(), OBJECT_ARRAY);
        commonTypes.put(INTEGER.getSignature(), INTEGER);
        commonTypes.put(EXCEPTION.getSignature(), EXCEPTION);
        commonTypes.put(STRINGBUFFER.getSignature(), STRINGBUFFER);
        commonTypes.put(STRINGBUILDER.getSignature(), STRINGBUILDER);
        commonTypes.put(LIST.getSignature(), LIST);
        commonTypes.put(ITERATOR.getSignature(), ITERATOR);
        ConstantsInitializer.initialize();
    }

    public static class TypeHolder {
        private Type t;
        private int consumed;

        public Type getType() {
            return this.t;
        }

        public int getConsumed() {
            return this.consumed;
        }

        public TypeHolder(Type type, int n) {
            this.t = type;
            this.consumed = n;
        }
    }
}

