# shenyu-client-golang

English | [简体中文](README_CN.md)

[![Build and Test](https://github.com/apache/shenyu-client-golang/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/apache/shenyu-client-golang/actions)
[![codecov.io](https://codecov.io/gh/apache/shenyu-client-golang/coverage.svg?branch=main)](https://app.codecov.io/gh/apache/shenyu-client-golang?branch=main)
[![GoDoc](https://godoc.org/github.com/apache/shenyu-client-golang?status.svg)](https://godoc.org/github.com/apache/shenyu-client-golang)

---

## Shenyu-client-golang

Shenyu-client-golang for Go client allows you to access ShenYu Gateway,it supports registory go service to ShenYu
Gateway.

---
## Supported Register Center to ShenYu Gateway

* **Http type Register**
* **Nacos type Register**
* **Zookeeper type Register**
* **Consul type Register**
* **Etcd type Register**

---

## Requirements

Supported Go version **over 1.13**

SDK Supported ShenYu version **over 2.4.3**

## Installation

Use `go get` to install SDK：

```sh
$ go get -u github.com/apache/shenyu-client-golang
```

## The Demo location

* shenyu-client-golang/example/**_client/main.go
---

## Get Start

* Http Example  [English](doc/HTTP_EN.md)  | [简体中文](doc/HTTP_CN.md)
* Nacos Example [English](doc/NACOS_EN.md)  | [简体中文](doc/NACOS_CN.md)
* Zookeeper Example [English](doc/ZK_EN.md)  | [简体中文](doc/ZK_CN.md)
* Consul Example [English](doc/CONSUL_EN.md)  | [简体中文](doc/CONSUL_CN.md)
* Etcd Example [English](doc/Etcd_EN.md)  | [简体中文](doc/Etcd_CN.md)

---

