/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.sis.feature.Field;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

final class PropertySingleton<V>
extends AbstractList<V> {
    private final Field<V> property;

    PropertySingleton(Field<V> property) {
        this.property = property;
    }

    @Override
    public int size() {
        return this.property.getValue() == null ? 0 : 1;
    }

    @Override
    public int indexOf(Object element) {
        return element != null && element.equals(this.property.getValue()) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.indexOf(element);
    }

    @Override
    public V get(int index) {
        V element;
        if (index == 0 && (element = this.property.getValue()) != null) {
            return element;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)88, (Object)index));
    }

    @Override
    public V set(int index, V element) {
        V previous;
        ArgumentChecks.ensureNonNull((String)"element", element);
        if (index == 0 && (previous = this.property.getValue()) != null) {
            this.property.setValue(element);
            ++this.modCount;
            return previous;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)88, (Object)index));
    }

    @Override
    public void add(int index, V element) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(Errors.format((short)88, (Object)index));
        }
        this.add(element);
    }

    @Override
    public boolean add(V element) {
        ArgumentChecks.ensureNonNull((String)"element", element);
        if (this.property.getValue() == null) {
            this.property.setValue(element);
            ++this.modCount;
            return true;
        }
        throw new IllegalStateException(Errors.format((short)42, (Object)this.property.getName()));
    }

    @Override
    public V remove(int index) {
        V previous;
        if (index == 0 && (previous = this.property.getValue()) != null) {
            this.clear();
            return previous;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)88, (Object)index));
    }

    final void clear(int c) {
        if (c != this.modCount) {
            throw new ConcurrentModificationException(String.valueOf(this.property.getName()));
        }
        this.property.setValue(null);
    }

    @Override
    public void clear() {
        this.property.setValue(null);
        ++this.modCount;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        V element = this.property.getValue();
        if (element == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = element;
        }
        return objectArray;
    }

    @Override
    public int hashCode() {
        int hashCode;
        V element = this.property.getValue();
        int n = hashCode = element != null ? 31 + element.hashCode() : 1;
        assert (hashCode == super.hashCode()) : hashCode;
        return hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof List) {
            V element = this.property.getValue();
            if (element == null) {
                return ((List)other).isEmpty();
            }
            Iterator it = ((List)other).iterator();
            return it.hasNext() && element.equals(it.next()) && !it.hasNext();
        }
        return false;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iter(this.property.getValue(), this.modCount);
    }

    private final class Iter
    implements Iterator<V> {
        private V element;
        private final int c;

        Iter(V element, int c) {
            this.element = element;
            this.c = c;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public V next() {
            Object v = this.element;
            if (v == null) {
                throw new NoSuchElementException();
            }
            this.element = null;
            return v;
        }

        @Override
        public void remove() {
            if (this.element != null) {
                throw new IllegalStateException();
            }
            PropertySingleton.this.clear(this.c);
        }
    }
}

