/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractSingleCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.temporal.TemporalDate;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractSingleCRS<TemporalDatum>
implements TemporalCRS {
    private static final long serialVersionUID = 369537220141768472L;
    private transient UnitConverter toSeconds;
    private transient long origin;

    public DefaultTemporalCRS(Map<String, ?> properties, TemporalDatum datum, DefaultDatumEnsemble<TemporalDatum> ensemble, TimeCS cs) {
        super(properties, TemporalDatum.class, datum, ensemble, (CoordinateSystem)cs);
        DefaultTemporalCRS.checkDimension(1, 1, (CoordinateSystem)cs);
        this.initializeConverter();
    }

    private DefaultTemporalCRS(DefaultTemporalCRS original, AbstractCS cs) {
        super(original, null, cs);
        this.initializeConverter();
    }

    protected DefaultTemporalCRS(TemporalCRS crs) {
        super((SingleCRS)crs);
        this.initializeConverter();
    }

    public static DefaultTemporalCRS castOrCopy(TemporalCRS object) {
        return object == null || object instanceof DefaultTemporalCRS ? (DefaultTemporalCRS)object : new DefaultTemporalCRS(object);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeConverter();
    }

    private void initializeConverter() {
        this.toSeconds = this.getUnit().getConverterTo(Units.SECOND);
        Temporal t = this.getOrigin();
        this.origin = t.getLong(ChronoField.INSTANT_SECONDS);
        int r = t.get(ChronoField.NANO_OF_SECOND);
        if (r != 0) {
            UnitConverter c = Units.converter(null, (Number)new Fraction(r, 1000000000));
            this.toSeconds = c.concatenate(this.toSeconds);
        }
    }

    @Override
    public Class<? extends TemporalCRS> getInterface() {
        return TemporalCRS.class;
    }

    @Override
    @XmlElement(name="temporalDatum", required=true)
    public TemporalDatum getDatum() {
        return (TemporalDatum)super.getDatum();
    }

    @Override
    public DefaultDatumEnsemble<TemporalDatum> getDatumEnsemble() {
        return super.getDatumEnsemble();
    }

    @XmlElement(name="timeCS", required=true)
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    public final Unit<Time> getUnit() {
        return super.getCoordinateSystem().getAxis(0).getUnit().asType(Time.class);
    }

    public final Temporal getOrigin() {
        return TemporalDate.toTemporal((Date)DatumOrEnsemble.asDatum(this).getOrigin());
    }

    @Override
    public DefaultTemporalCRS forConvention(AxesConvention convention) {
        return (DefaultTemporalCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        return new DefaultTemporalCRS(this, cs);
    }

    public Instant toInstant(double value) {
        if (Double.isFinite(value)) {
            value = this.toSeconds.convert(value);
            long t = Math.round(value);
            return Instant.ofEpochSecond(Math.addExact(t, this.origin), Math.round((value - (double)t) * 1.0E9));
        }
        return null;
    }

    public Date toDate(double value) {
        if (Double.isFinite(value)) {
            value = this.toSeconds.convert(value);
            long t = Math.round(value);
            long ms = Math.addExact(t, this.origin);
            ms = Math.multiplyExact(ms, 1000);
            ms = Math.addExact(Math.round((value - (double)t) * 1000.0), ms);
            return new Date(ms);
        }
        return null;
    }

    public Duration toDuration(double delta) {
        if (Double.isFinite(delta *= Units.derivative((UnitConverter)this.toSeconds, (double)Double.NaN))) {
            long t = Math.round(delta);
            return Duration.ofSeconds(t, Math.round((delta - (double)t) * 1.0E9));
        }
        return null;
    }

    public double toValue(Instant time) {
        if (time != null) {
            double t = Math.subtractExact(time.getEpochSecond(), this.origin);
            return this.toSeconds.inverse().convert(t += (double)time.getNano() / 1.0E9);
        }
        return Double.NaN;
    }

    public double toValue(Date time) {
        if (time != null) {
            long ms = time.getTime();
            long t = ms / 1000L;
            t = Math.subtractExact(t, this.origin);
            return this.toSeconds.inverse().convert((double)t + (double)(ms %= 1000L) / 1000.0);
        }
        return Double.NaN;
    }

    public double toValue(Duration delta) {
        if (delta != null) {
            double t = delta.getSeconds();
            t += (double)delta.getNano() / 1.0E9;
            return t *= Units.derivative((UnitConverter)this.toSeconds.inverse(), (double)Double.NaN);
        }
        return Double.NaN;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultTemporalCRS.isBaseCRS(formatter) ? "BaseTimeCRS" : "TimeCRS";
    }

    @Override
    final void formatDatum(Formatter formatter) {
        DefaultTemporalCRS.formatDatum(formatter, this, this.getDatum(), DefaultTemporalDatum::castOrCopy, DatumOrEnsemble::asDatum);
    }

    private DefaultTemporalCRS() {
    }

    private void setDatum(TemporalDatum value) {
        this.setDatum("temporalDatum", value);
        if (super.getCoordinateSystem() != null) {
            this.initializeConverter();
        }
    }

    private void setCoordinateSystem(TimeCS cs) {
        this.setCoordinateSystem("timeCS", (CoordinateSystem)cs);
        if (this.toSeconds == null && super.getDatum() != null) {
            this.initializeConverter();
        }
    }
}

