/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.Containers;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;

public class CoordinateOperationContext
implements Localized {
    private DefaultExtent areaOfInterest;
    private double desiredAccuracy;
    private DirectPosition constantCoordinates;
    private Locale locale;
    private transient Filter logFilter;

    public CoordinateOperationContext() {
    }

    public CoordinateOperationContext(Extent area, double accuracy) {
        ArgumentChecks.ensurePositive((String)"accuracy", (double)accuracy);
        if (area != null) {
            this.areaOfInterest = new DefaultExtent(area);
        }
        this.desiredAccuracy = accuracy;
    }

    public static CoordinateOperationContext fromBoundingBox(GeographicBoundingBox areaOfInterest) {
        if (areaOfInterest != null && (areaOfInterest.getSouthBoundLatitude() > -90.0 || areaOfInterest.getNorthBoundLatitude() < 90.0 || areaOfInterest.getWestBoundLongitude() > -180.0 || areaOfInterest.getEastBoundLongitude() < 180.0)) {
            CoordinateOperationContext context = new CoordinateOperationContext();
            context.setAreaOfInterest(areaOfInterest);
            return context;
        }
        return null;
    }

    public Extent getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public void setAreaOfInterest(Extent area) {
        this.areaOfInterest = area != null ? new DefaultExtent(area) : null;
    }

    public void setAreaOfInterest(GeographicBoundingBox area) {
        this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, area);
    }

    public void addAreaOfInterest(GeographicBoundingBox area) {
        if (area != null) {
            if (this.areaOfInterest == null) {
                this.setAreaOfInterest(area);
            } else {
                this.areaOfInterest.getGeographicElements().add(area);
            }
        }
    }

    public void addAreaOfInterest(Envelope area) {
        if (area != null) {
            try {
                if (this.areaOfInterest == null) {
                    this.areaOfInterest = new DefaultExtent();
                }
                this.areaOfInterest.addElements(area);
            }
            catch (TransformException e) {
                this.recoverableException("addAreaOfInterest", (Exception)((Object)e));
            }
        }
    }

    static DefaultExtent setGeographicBoundingBox(DefaultExtent areaOfInterest, GeographicBoundingBox bbox) {
        if (areaOfInterest != null) {
            areaOfInterest.setGeographicElements((Collection)Containers.singletonOrEmpty((Object)bbox));
        } else if (bbox != null) {
            areaOfInterest = new DefaultExtent(null, (GeographicExtent)bbox, null, null);
        }
        return areaOfInterest;
    }

    public double getDesiredAccuracy() {
        return this.desiredAccuracy;
    }

    public void setDesiredAccuracy(double accuracy) {
        ArgumentChecks.ensurePositive((String)"accuracy", (double)accuracy);
        this.desiredAccuracy = accuracy;
    }

    final Predicate<CoordinateOperation> getOperationFilter() {
        return null;
    }

    public DirectPosition getConstantCoordinates() {
        return this.constantCoordinates;
    }

    public void setConstantCoordinates(DirectPosition coordinates) {
        this.constantCoordinates = coordinates;
    }

    final boolean canReadFromCache() {
        return this.getAreaOfInterest() == null && this.getDesiredAccuracy() == 0.0 && this.getConstantCoordinates() == null;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Filter getLogFilter() {
        return this.logFilter;
    }

    public void setLogFilter(Filter logFilter) {
        this.logFilter = logFilter;
    }

    private void recoverableException(String method, Exception e) {
        LogRecord record = new LogRecord(Level.FINE, e.getLocalizedMessage());
        record.setThrown(e);
        record.setSourceMethodName(method);
        CoordinateOperationContext.log(this, CoordinateOperationContext.class, AbstractCoordinateOperation.LOGGER, record);
    }

    static void log(CoordinateOperationContext context, Class<?> caller, Logger logger, LogRecord record) {
        Filter logFilter;
        record.setSourceClassName(caller.getCanonicalName());
        record.setLoggerName(logger.getName());
        if (context != null && (logFilter = context.getLogFilter()) != null && !logFilter.isLoggable(record)) {
            return;
        }
        logger.log(record);
    }
}

