/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.common.Attributes;
import com.linecorp.armeria.common.AttributesBuilder;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.loadbalancer.Weighted;
import com.linecorp.armeria.common.util.DomainSocketAddress;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.SchemeAndAuthority;
import com.linecorp.armeria.internal.common.util.DomainSocketUtil;
import com.linecorp.armeria.internal.common.util.IpAddrUtil;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.net.InternetDomainName;
import io.netty.util.AttributeKey;
import io.netty.util.NetUtil;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class Endpoint
implements EndpointGroup,
Weighted,
Comparable<Endpoint> {
    private static final Comparator<Endpoint> COMPARATOR = Comparator.comparing(Endpoint::host).thenComparing(e -> e.ipAddr, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(e -> e.port);
    private static final int DEFAULT_WEIGHT = 1000;
    private static final Cache<String, Endpoint> cache = Caffeine.newBuilder().maximumSize(8192L).build();
    private final Type type;
    private final String host;
    @Nullable
    private final String ipAddr;
    private final int port;
    private final int weight;
    private final List<Endpoint> endpoints;
    private final String authority;
    @Nullable
    private final Attributes attributes;
    @Nullable
    private CompletableFuture<Endpoint> selectFuture;
    @Nullable
    private CompletableFuture<List<Endpoint>> whenReadyFuture;
    @Nullable
    private InetSocketAddress socketAddress;
    private int hashCode;

    public static Endpoint parse(String authority) {
        Objects.requireNonNull(authority, "authority");
        Preconditions.checkArgument(!authority.isEmpty(), "authority is empty");
        return cache.get(authority, key -> {
            SchemeAndAuthority schemeAndAuthority = SchemeAndAuthority.of(null, key);
            int port = schemeAndAuthority.port() == -1 ? 0 : schemeAndAuthority.port();
            return Endpoint.create(schemeAndAuthority.host(), port, true);
        });
    }

    public static Endpoint of(String host, int port) {
        Endpoint.validatePort("port", port);
        return Endpoint.create(host, port, true);
    }

    public static Endpoint of(String host) {
        return Endpoint.create(host, 0, true);
    }

    @UnstableApi
    public static Endpoint of(SocketAddress addr) {
        Objects.requireNonNull(addr, "addr");
        if (addr instanceof io.netty.channel.unix.DomainSocketAddress) {
            addr = DomainSocketAddress.of((io.netty.channel.unix.DomainSocketAddress)addr);
        }
        if (addr instanceof DomainSocketAddress) {
            DomainSocketAddress domainSocketAddr = (DomainSocketAddress)addr;
            Endpoint endpoint = new Endpoint(Type.DOMAIN_SOCKET, domainSocketAddr.authority(), DomainSocketUtil.DOMAIN_SOCKET_IP, 1, 1000, null);
            endpoint.socketAddress = domainSocketAddr;
            return endpoint;
        }
        Preconditions.checkArgument(addr instanceof InetSocketAddress, "unsupported address: %s", (Object)addr);
        InetSocketAddress inetAddr = (InetSocketAddress)addr;
        String ipAddr = inetAddr.isUnresolved() ? null : inetAddr.getAddress().getHostAddress();
        Endpoint endpoint = Endpoint.of(inetAddr.getHostString(), inetAddr.getPort()).withIpAddr(ipAddr);
        if (endpoint.host.equals(inetAddr.getHostString())) {
            endpoint.socketAddress = inetAddr;
        }
        return endpoint;
    }

    @UnstableApi
    public static Endpoint unsafeCreate(String host, int port) {
        return Endpoint.create(host, port, false);
    }

    private static Endpoint create(String host, int port, boolean validateHost) {
        String normalizedIpAddr = IpAddrUtil.normalize(host);
        if (normalizedIpAddr != null) {
            return new Endpoint(Type.IP_ONLY, normalizedIpAddr, normalizedIpAddr, port, 1000, null);
        }
        if (Endpoint.isDomainSocketAuthority(host)) {
            return new Endpoint(Type.DOMAIN_SOCKET, host, DomainSocketUtil.DOMAIN_SOCKET_IP, 1, 1000, null);
        }
        if (validateHost) {
            host = Endpoint.normalizeHost(host);
        }
        return new Endpoint(Type.HOSTNAME_ONLY, host, null, port, 1000, null);
    }

    private static boolean isDomainSocketAuthority(String host) {
        return host.length() > 7 && host.startsWith("unix%3") && Ascii.toUpperCase(host.charAt(6)) == 'A';
    }

    private static String normalizeHost(String host) {
        boolean hasTrailingDot = Endpoint.hasTrailingDot(host);
        host = InternetDomainName.from(host).toString();
        assert (!Endpoint.hasTrailingDot(host)) : host;
        if (hasTrailingDot) {
            host = host + '.';
        }
        return host;
    }

    private static boolean hasTrailingDot(String host) {
        return !host.isEmpty() && host.charAt(host.length() - 1) == '.';
    }

    private Endpoint(Type type, String host, @Nullable String ipAddr, int port, int weight, @Nullable Attributes attributes) {
        this.type = type;
        this.host = host;
        this.ipAddr = ipAddr;
        this.port = port;
        this.weight = weight;
        this.endpoints = ImmutableList.of(this);
        assert (ipAddr == null && type == Type.HOSTNAME_ONLY || ipAddr != null && type != Type.HOSTNAME_ONLY);
        assert (type != Type.DOMAIN_SOCKET || port == 1 && DomainSocketUtil.DOMAIN_SOCKET_IP.equals(ipAddr));
        this.authority = Endpoint.generateAuthority(type, host, port);
        this.attributes = attributes;
    }

    private static String generateAuthority(Type type, String host, int port) {
        switch (type.ordinal()) {
            case 3: {
                return host;
            }
            case 1: {
                if (!Endpoint.isIpV6(host)) break;
                if (port != 0) {
                    return '[' + host + "]:" + port;
                }
                return '[' + host + ']';
            }
        }
        if (Endpoint.hasTrailingDot(host)) {
            host = host.substring(0, host.length() - 1);
        }
        return port != 0 ? host + ':' + port : host;
    }

    @Override
    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    @Override
    public void addListener(Consumer<? super List<Endpoint>> listener, boolean notifyLatestEndpoints) {
        if (notifyLatestEndpoints) {
            listener.accept(this.endpoints);
        }
    }

    @Override
    public EndpointSelectionStrategy selectionStrategy() {
        return EndpointSelectionStrategy.weightedRoundRobin();
    }

    @Override
    @Nonnull
    public Endpoint selectNow(ClientRequestContext ctx) {
        return this;
    }

    @Override
    @Deprecated
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.select(ctx, executor);
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor) {
        if (this.selectFuture == null) {
            this.selectFuture = UnmodifiableFuture.completedFuture(this);
        }
        return this.selectFuture;
    }

    @Override
    public long selectionTimeoutMillis() {
        return 0L;
    }

    @Override
    public CompletableFuture<List<Endpoint>> whenReady() {
        if (this.whenReadyFuture == null) {
            this.whenReadyFuture = UnmodifiableFuture.completedFuture(this.endpoints);
        }
        return this.whenReadyFuture;
    }

    Type type() {
        return this.type;
    }

    public String host() {
        return this.host;
    }

    @UnstableApi
    public Endpoint withHost(String host) {
        Objects.requireNonNull(host, "host");
        if (host.equals(this.host)) {
            return this;
        }
        String normalizedIpAddr = IpAddrUtil.normalize(host);
        if (normalizedIpAddr != null) {
            return new Endpoint(Type.IP_ONLY, normalizedIpAddr, normalizedIpAddr, this.port, this.weight, this.attributes);
        }
        if (Endpoint.isDomainSocketAuthority(host)) {
            return new Endpoint(Type.DOMAIN_SOCKET, host, DomainSocketUtil.DOMAIN_SOCKET_IP, 1, this.weight, this.attributes);
        }
        host = Endpoint.normalizeHost(host);
        return new Endpoint(this.ipAddr != null ? Type.HOSTNAME_AND_IP : Type.HOSTNAME_ONLY, host, this.ipAddr, this.port, this.weight, this.attributes);
    }

    @Nullable
    public String ipAddr() {
        return this.ipAddr;
    }

    public boolean hasIpAddr() {
        return this.ipAddr() != null;
    }

    public boolean isIpAddrOnly() {
        return this.type == Type.IP_ONLY;
    }

    @Nullable
    public StandardProtocolFamily ipFamily() {
        if (this.ipAddr == null) {
            return null;
        }
        return Endpoint.isIpV6(this.ipAddr) ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
    }

    private static boolean isIpV6(String ipAddr) {
        return ipAddr.indexOf(58) >= 0;
    }

    @UnstableApi
    public boolean isDomainSocket() {
        return this.type == Type.DOMAIN_SOCKET;
    }

    public int port() {
        if (this.port == 0) {
            throw new IllegalStateException("port not specified");
        }
        return this.port;
    }

    public int port(int defaultValue) {
        return this.port != 0 ? this.port : defaultValue;
    }

    public boolean hasPort() {
        return this.port != 0;
    }

    public Endpoint withPort(int port) {
        Endpoint.validatePort("port", port);
        if (this.port == port || this.isDomainSocket()) {
            return this;
        }
        return new Endpoint(this.type, this.host, this.ipAddr, port, this.weight, this.attributes);
    }

    public Endpoint withoutPort() {
        if (this.port == 0 || this.isDomainSocket()) {
            return this;
        }
        return new Endpoint(this.type, this.host, this.ipAddr, 0, this.weight, this.attributes);
    }

    public Endpoint withDefaultPort(int defaultPort) {
        Endpoint.validatePort("defaultPort", defaultPort);
        if (this.port != 0) {
            return this;
        }
        return new Endpoint(this.type, this.host, this.ipAddr, defaultPort, this.weight, this.attributes);
    }

    @UnstableApi
    public Endpoint withDefaultPort(SessionProtocol protocol) {
        Objects.requireNonNull(protocol, "protocol");
        return this.withDefaultPort(protocol.defaultPort());
    }

    public Endpoint withoutDefaultPort(int defaultPort) {
        Endpoint.validatePort("defaultPort", defaultPort);
        if (this.isDomainSocket()) {
            return this;
        }
        if (this.port == defaultPort) {
            return new Endpoint(this.type, this.host, this.ipAddr, 0, this.weight, this.attributes);
        }
        return this;
    }

    @UnstableApi
    public Endpoint withoutDefaultPort(SessionProtocol protocol) {
        Objects.requireNonNull(protocol, "protocol");
        return this.withoutDefaultPort(protocol.defaultPort());
    }

    public Endpoint withIpAddr(@Nullable String ipAddr) {
        if (this.isDomainSocket()) {
            return this;
        }
        if (ipAddr == null) {
            return this.withoutIpAddr();
        }
        String normalizedIpAddr = IpAddrUtil.normalize(ipAddr);
        Preconditions.checkArgument(normalizedIpAddr != null, "ipAddr: %s (expected: a valid IP address)", (Object)ipAddr);
        if (normalizedIpAddr.equals(this.ipAddr)) {
            return this;
        }
        if (this.isIpAddrOnly()) {
            return new Endpoint(Type.IP_ONLY, normalizedIpAddr, normalizedIpAddr, this.port, this.weight, this.attributes);
        }
        return new Endpoint(Type.HOSTNAME_AND_IP, this.host, normalizedIpAddr, this.port, this.weight, this.attributes);
    }

    public Endpoint withInetAddress(InetAddress address) {
        Objects.requireNonNull(address, "address");
        return this.withIpAddr(address.getHostAddress());
    }

    private Endpoint withoutIpAddr() {
        if (this.ipAddr == null) {
            return this;
        }
        if (this.isIpAddrOnly()) {
            throw new IllegalStateException("can't clear the IP address if host name is an IP address: " + this);
        }
        assert (this.type == Type.HOSTNAME_AND_IP) : this.type;
        return new Endpoint(Type.HOSTNAME_ONLY, this.host, null, this.port, this.weight, this.attributes);
    }

    @UnstableApi
    public Endpoint withoutTrailingDot() {
        if (!Endpoint.hasTrailingDot(this.host)) {
            return this;
        }
        String stripped = this.host.substring(0, this.host.length() - 1);
        return new Endpoint(this.type, stripped, this.ipAddr, this.port, this.weight, this.attributes);
    }

    public Endpoint withWeight(int weight) {
        Endpoint.validateWeight(weight);
        if (this.weight == weight) {
            return this;
        }
        return new Endpoint(this.type, this.host, this.ipAddr, this.port, weight, this.attributes);
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public String authority() {
        return this.authority;
    }

    @Nullable
    @UnstableApi
    public <T> T attr(AttributeKey<T> key) {
        Objects.requireNonNull(key, "key");
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.attr(key);
    }

    @UnstableApi
    public <T> Endpoint withAttr(AttributeKey<T> key, @Nullable T value) {
        Objects.requireNonNull(key, "key");
        if (this.attributes == null) {
            if (value == null) {
                return this;
            }
            return this.replaceAttrs(Attributes.of(key, value));
        }
        if (this.attributes.attr(key) == value) {
            return this;
        }
        AttributesBuilder attributesBuilder = this.attributes.toBuilder();
        attributesBuilder.set((AttributeKey)key, (Object)value);
        return this.replaceAttrs(attributesBuilder.build());
    }

    @UnstableApi
    public Endpoint withAttrs(Attributes newAttributes) {
        Objects.requireNonNull(newAttributes, "newAttributes");
        if (newAttributes.isEmpty()) {
            return this;
        }
        if (this.attrs().isEmpty()) {
            return this.replaceAttrs(newAttributes);
        }
        AttributesBuilder builder = this.attrs().toBuilder();
        newAttributes.attrs().forEachRemaining(entry -> {
            AttributeKey key = (AttributeKey)entry.getKey();
            builder.set(key, entry.getValue());
        });
        return new Endpoint(this.type, this.host, this.ipAddr, this.port, this.weight, builder.build());
    }

    @UnstableApi
    public Endpoint replaceAttrs(Attributes newAttributes) {
        Objects.requireNonNull(newAttributes, "newAttributes");
        if (this.attrs().isEmpty() && newAttributes.isEmpty()) {
            return this;
        }
        return new Endpoint(this.type, this.host, this.ipAddr, this.port, this.weight, newAttributes);
    }

    @UnstableApi
    public Attributes attrs() {
        if (this.attributes == null) {
            return Attributes.of();
        }
        return this.attributes;
    }

    public URI toUri(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        return this.toUri(scheme, null);
    }

    public URI toUri(String scheme, @Nullable String path) {
        Objects.requireNonNull(scheme, "scheme");
        scheme = ArmeriaHttpUtil.schemeValidateAndNormalize(scheme);
        try {
            return new URI(scheme, this.authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public URI toUri(SessionProtocol sessionProtocol) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        return this.toUri(sessionProtocol, null);
    }

    public URI toUri(SessionProtocol sessionProtocol, @Nullable String path) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        return this.toUri(Scheme.of(SerializationFormat.NONE, sessionProtocol), path);
    }

    public URI toUri(Scheme scheme) {
        Objects.requireNonNull(scheme, "scheme");
        return this.toUri(scheme, null);
    }

    public URI toUri(Scheme scheme, @Nullable String path) {
        Objects.requireNonNull(scheme, "scheme");
        try {
            return new URI(scheme.uriText(), this.authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @UnstableApi
    public InetSocketAddress toSocketAddress(int defaultPort) {
        InetSocketAddress socketAddress = this.socketAddress;
        if (socketAddress != null) {
            return socketAddress;
        }
        InetSocketAddress newSocketAddress = this.toSocketAddress0(defaultPort);
        if (this.hasPort()) {
            this.socketAddress = newSocketAddress;
        }
        return newSocketAddress;
    }

    private InetSocketAddress toSocketAddress0(int defaultPort) {
        int port;
        if (this.isDomainSocket()) {
            String decodedHost;
            try {
                decodedHost = URLDecoder.decode(this.host, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            assert (decodedHost.startsWith("unix:")) : decodedHost;
            return DomainSocketAddress.of(decodedHost.substring(5));
        }
        int n = port = this.hasPort() ? this.port : defaultPort;
        if (!this.hasIpAddr()) {
            return InetSocketAddress.createUnresolved(this.host, port);
        }
        assert (this.ipAddr != null);
        try {
            return new InetSocketAddress(InetAddress.getByAddress(this.isIpAddrOnly() ? null : this.host, NetUtil.createByteArrayFromIpAddressString(this.ipAddr)), port);
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    private static void validatePort(String name, int port) {
        Preconditions.checkArgument(port > 0 && port <= 65535, "%s: %s (expected: 1-65535)", (Object)name, port);
    }

    private static void validateWeight(int weight) {
        Preconditions.checkArgument(weight >= 0, "weight: %s (expected: >= 0)", weight);
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public void close() {
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint that = (Endpoint)obj;
        return this.hashCode() == that.hashCode() && this.host.equals(that.host) && Objects.equals(this.ipAddr, that.ipAddr) && this.port == that.port;
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode != 0) {
            return hashCode;
        }
        int newHashCode = (this.host.hashCode() * 31 + Objects.hashCode(this.ipAddr)) * 31 + this.port;
        if (newHashCode == 0) {
            newHashCode = 1;
        }
        this.hashCode = newHashCode;
        return newHashCode;
    }

    @Override
    public int compareTo(Endpoint that) {
        return COMPARATOR.compare(this, that);
    }

    public String toString() {
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append("Endpoint{").append(this.authority);
            if (this.type == Type.HOSTNAME_AND_IP) {
                buf.append(", ipAddr=").append(this.ipAddr);
            }
            String string = buf.append(", weight=").append(this.weight).append('}').toString();
            return string;
        }
    }

    static enum Type {
        HOSTNAME_ONLY,
        IP_ONLY,
        HOSTNAME_AND_IP,
        DOMAIN_SOCKET;

    }
}

