/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import com.linecorp.armeria.client.circuitbreaker.ClientCircuitBreakerGenerator;
import com.linecorp.armeria.client.circuitbreaker.DefaultCircuitBreakerCallback;
import com.linecorp.armeria.client.circuitbreaker.FailFastException;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.circuitbreaker.CircuitBreakerCallback;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultCircuitBreakerClientHandler
implements CircuitBreakerClientHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCircuitBreakerClientHandler.class);
    private final ClientCircuitBreakerGenerator<CircuitBreaker> mapping;

    DefaultCircuitBreakerClientHandler(ClientCircuitBreakerGenerator<CircuitBreaker> mapping) {
        this.mapping = mapping;
    }

    @Override
    @Nullable
    public CircuitBreakerCallback tryRequest(ClientRequestContext ctx, Request req) {
        CircuitBreaker circuitBreaker;
        try {
            circuitBreaker = Objects.requireNonNull(this.mapping.get(ctx, req), "circuitBreaker");
        }
        catch (Throwable t) {
            logger.warn("Failed to get a circuit breaker from mapping ({}) for context ({})", this.mapping, ctx, t);
            return null;
        }
        if (!circuitBreaker.tryRequest()) {
            throw new FailFastException(circuitBreaker);
        }
        if (circuitBreaker instanceof CircuitBreakerCallback) {
            return (CircuitBreakerCallback)((Object)circuitBreaker);
        }
        return new DefaultCircuitBreakerCallback(circuitBreaker);
    }
}

