/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.websocket;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.server.websocket.DefaultWebSocketService;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceOptions;
import com.linecorp.armeria.server.websocket.WebSocketService;
import com.linecorp.armeria.server.websocket.WebSocketServiceHandler;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public final class WebSocketServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServiceBuilder.class);
    private static final String ANY_ORIGIN = "*";
    static final int DEFAULT_MAX_FRAME_PAYLOAD_LENGTH = 65535;
    static final ServiceOptions DEFAULT_OPTIONS = ServiceOptions.builder().requestTimeoutMillis(0L).maxRequestLength(0L).requestAutoAbortDelayMillis(5000L).build();
    private final WebSocketServiceHandler handler;
    private int maxFramePayloadLength = 65535;
    private boolean allowMaskMismatch;
    private Set<String> subprotocols = ImmutableSet.of();
    @Nullable
    private Set<String> allowedOrigins;
    @Nullable
    private Predicate<? super String> originPredicate;
    private boolean aggregateContinuation;
    @Nullable
    private HttpService fallbackService;
    private ServiceOptions serviceOptions = DEFAULT_OPTIONS;

    WebSocketServiceBuilder(WebSocketServiceHandler handler) {
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    public WebSocketServiceBuilder maxFramePayloadLength(int maxFramePayloadLength) {
        Preconditions.checkArgument(maxFramePayloadLength > 0, "maxFramePayloadLength: %s (expected: > 0)", maxFramePayloadLength);
        this.maxFramePayloadLength = maxFramePayloadLength;
        return this;
    }

    public WebSocketServiceBuilder allowMaskMismatch(boolean allowMaskMismatch) {
        this.allowMaskMismatch = allowMaskMismatch;
        return this;
    }

    public WebSocketServiceBuilder subprotocols(String ... subprotocols) {
        return this.subprotocols(ImmutableSet.copyOf(Objects.requireNonNull(subprotocols, "subprotocols")));
    }

    public WebSocketServiceBuilder subprotocols(Iterable<String> subprotocols) {
        this.subprotocols = ImmutableSet.copyOf(Objects.requireNonNull(subprotocols, "subprotocols"));
        return this;
    }

    public WebSocketServiceBuilder aggregateContinuation(boolean aggregateContinuation) {
        this.aggregateContinuation = aggregateContinuation;
        return this;
    }

    public WebSocketServiceBuilder allowedOrigins(String ... allowedOrigins) {
        return this.allowedOrigins(ImmutableSet.copyOf(Objects.requireNonNull(allowedOrigins, "allowedOrigins")));
    }

    public WebSocketServiceBuilder allowedOrigins(Iterable<String> allowedOrigins) {
        Preconditions.checkState(this.originPredicate == null, "allowedOrigins and originPredicate are mutually exclusive.");
        this.allowedOrigins = WebSocketServiceBuilder.validateOrigins(allowedOrigins);
        return this;
    }

    public WebSocketServiceBuilder allowedOrigin(Predicate<? super String> predicate) {
        Preconditions.checkState(this.allowedOrigins == null, "allowedOrigins and originPredicate are mutually exclusive.");
        this.originPredicate = Objects.requireNonNull(predicate, "predicate");
        return this;
    }

    public WebSocketServiceBuilder allowedOrigin(String regex) {
        return this.allowedOrigin(Pattern.compile(Objects.requireNonNull(regex, "regex")));
    }

    public WebSocketServiceBuilder allowedOrigin(Pattern regex) {
        return this.allowedOrigin(Objects.requireNonNull(regex, "regex").asPredicate());
    }

    private static Set<String> validateOrigins(Iterable<String> allowedOrigins) {
        Set copied = ImmutableSet.copyOf(Objects.requireNonNull(allowedOrigins, "allowedOrigins")).stream().map(Ascii::toLowerCase).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument(!copied.isEmpty(), "allowedOrigins is empty. (expected: non-empty)");
        if (copied.contains(ANY_ORIGIN) && copied.size() > 1) {
            logger.warn("Any origin (*) has been already included. Other origins ({}) will be ignored.", (Object)copied.stream().filter(c -> !ANY_ORIGIN.equals(c)).collect(Collectors.joining(",")));
        }
        return copied;
    }

    public WebSocketServiceBuilder serviceOptions(ServiceOptions serviceOptions) {
        Objects.requireNonNull(serviceOptions, "serviceOptions");
        this.serviceOptions = serviceOptions;
        return this;
    }

    public WebSocketServiceBuilder fallbackService(HttpService fallbackService) {
        this.fallbackService = Objects.requireNonNull(fallbackService, "fallbackService");
        Preconditions.checkArgument(!(fallbackService instanceof WebSocketService), "fallbackService must not be a WebSocketService.");
        return this;
    }

    public WebSocketService build() {
        Predicate<? super String> originPredicate;
        boolean allowAnyOrigin;
        if (this.allowedOrigins != null) {
            allowAnyOrigin = this.allowedOrigins.contains(ANY_ORIGIN);
            originPredicate = this.allowedOrigins::contains;
        } else {
            allowAnyOrigin = false;
            originPredicate = this.originPredicate;
        }
        return new DefaultWebSocketService(this.handler, this.fallbackService, this.maxFramePayloadLength, this.allowMaskMismatch, this.subprotocols, allowAnyOrigin, originPredicate, this.aggregateContinuation, this.serviceOptions);
    }
}

