/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultRpcRequest;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public interface RpcRequest
extends Request {
    public static RpcRequest of(Class<?> serviceType, String method) {
        return new DefaultRpcRequest(serviceType, null, method, ImmutableList.of());
    }

    public static RpcRequest of(Class<?> serviceType, String method, @Nullable Object parameter) {
        List<Object> parameters = parameter == null ? DefaultRpcRequest.SINGLE_NULL_PARAM : ImmutableList.of(parameter);
        return new DefaultRpcRequest(serviceType, null, method, (Iterable<?>)parameters);
    }

    public static RpcRequest of(Class<?> serviceType, String method, Iterable<?> params) {
        return RpcRequest.of(serviceType, null, method, params);
    }

    public static RpcRequest of(Class<?> serviceType, @Nullable String serviceName, String method, Iterable<?> params) {
        Objects.requireNonNull(params, "params");
        return new DefaultRpcRequest(serviceType, serviceName, method, params);
    }

    public static RpcRequest of(Class<?> serviceType, String method, Object ... params) {
        Objects.requireNonNull(params, "params");
        return new DefaultRpcRequest(serviceType, null, method, params);
    }

    public Class<?> serviceType();

    default public String serviceName() {
        return this.serviceType().getName();
    }

    public String method();

    public List<Object> params();
}

