/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.analysis.QueryTraversalContext;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldArgumentEnvironment;
import graphql.analysis.QueryVisitorFieldArgumentEnvironmentImpl;
import graphql.analysis.QueryVisitorFieldArgumentInputValue;
import graphql.analysis.QueryVisitorFieldArgumentInputValueImpl;
import graphql.analysis.QueryVisitorFieldArgumentValueEnvironmentImpl;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorFieldEnvironmentImpl;
import graphql.analysis.QueryVisitorFragmentDefinitionEnvironmentImpl;
import graphql.analysis.QueryVisitorFragmentSpreadEnvironmentImpl;
import graphql.analysis.QueryVisitorInlineFragmentEnvironmentImpl;
import graphql.execution.CoercedVariables;
import graphql.execution.ValuesResolver;
import graphql.execution.conditional.ConditionalNodes;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectField;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Locale;
import java.util.Map;

@Internal
public class NodeVisitorWithTypeTracking
extends NodeVisitorStub {
    private final QueryVisitor preOrderCallback;
    private final QueryVisitor postOrderCallback;
    private final Map<String, Object> variables;
    private final GraphQLSchema schema;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();

    public NodeVisitorWithTypeTracking(QueryVisitor preOrderCallback, QueryVisitor postOrderCallback, Map<String, Object> variables, GraphQLSchema schema, Map<String, FragmentDefinition> fragmentsByName) {
        this.preOrderCallback = preOrderCallback;
        this.postOrderCallback = postOrderCallback;
        this.variables = variables;
        this.schema = schema;
        this.fragmentsByName = fragmentsByName;
    }

    @Override
    public TraversalControl visitDirective(Directive node, TraverserContext<Node> context) {
        return TraversalControl.ABORT;
    }

    @Override
    public TraversalControl visitInlineFragment(InlineFragment inlineFragment, TraverserContext<Node> context) {
        GraphQLCompositeType fragmentCondition;
        QueryTraversalContext parentEnv = context.getVarFromParents(QueryTraversalContext.class);
        GraphQLContext graphQLContext = parentEnv.getGraphQLContext();
        if (!this.conditionalNodes.shouldInclude(inlineFragment, this.variables, null, graphQLContext)) {
            return TraversalControl.ABORT;
        }
        QueryVisitorInlineFragmentEnvironmentImpl inlineFragmentEnvironment = new QueryVisitorInlineFragmentEnvironmentImpl(inlineFragment, context, this.schema);
        if (context.getPhase() == TraverserContext.Phase.LEAVE) {
            this.postOrderCallback.visitInlineFragment(inlineFragmentEnvironment);
            return TraversalControl.CONTINUE;
        }
        this.preOrderCallback.visitInlineFragment(inlineFragmentEnvironment);
        if (inlineFragment.getTypeCondition() != null) {
            TypeName typeCondition = inlineFragment.getTypeCondition();
            fragmentCondition = (GraphQLCompositeType)this.schema.getType(typeCondition.getName());
        } else {
            fragmentCondition = parentEnv.getUnwrappedOutputType();
        }
        context.setVar(QueryTraversalContext.class, new QueryTraversalContext(fragmentCondition, parentEnv.getEnvironment(), inlineFragment, graphQLContext));
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitFragmentDefinition(FragmentDefinition fragmentDefinition, TraverserContext<Node> context) {
        QueryTraversalContext parentEnv = context.getVarFromParents(QueryTraversalContext.class);
        GraphQLContext graphQLContext = parentEnv.getGraphQLContext();
        if (!this.conditionalNodes.shouldInclude(fragmentDefinition, this.variables, null, graphQLContext)) {
            return TraversalControl.ABORT;
        }
        QueryVisitorFragmentDefinitionEnvironmentImpl fragmentEnvironment = new QueryVisitorFragmentDefinitionEnvironmentImpl(fragmentDefinition, context, this.schema);
        if (context.getPhase() == TraverserContext.Phase.LEAVE) {
            this.postOrderCallback.visitFragmentDefinition(fragmentEnvironment);
            return TraversalControl.CONTINUE;
        }
        this.preOrderCallback.visitFragmentDefinition(fragmentEnvironment);
        GraphQLCompositeType typeCondition = (GraphQLCompositeType)this.schema.getType(fragmentDefinition.getTypeCondition().getName());
        context.setVar(QueryTraversalContext.class, new QueryTraversalContext(typeCondition, parentEnv.getEnvironment(), fragmentDefinition, graphQLContext));
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
        QueryTraversalContext parentEnv = context.getVarFromParents(QueryTraversalContext.class);
        GraphQLContext graphQLContext = parentEnv.getGraphQLContext();
        if (!this.conditionalNodes.shouldInclude(fragmentSpread, this.variables, null, graphQLContext)) {
            return TraversalControl.ABORT;
        }
        FragmentDefinition fragmentDefinition = this.fragmentsByName.get(fragmentSpread.getName());
        if (!this.conditionalNodes.shouldInclude(fragmentDefinition, this.variables, null, graphQLContext)) {
            return TraversalControl.ABORT;
        }
        QueryVisitorFragmentSpreadEnvironmentImpl fragmentSpreadEnvironment = new QueryVisitorFragmentSpreadEnvironmentImpl(fragmentSpread, fragmentDefinition, context, this.schema);
        if (context.getPhase() == TraverserContext.Phase.LEAVE) {
            this.postOrderCallback.visitFragmentSpread(fragmentSpreadEnvironment);
            return TraversalControl.CONTINUE;
        }
        this.preOrderCallback.visitFragmentSpread(fragmentSpreadEnvironment);
        GraphQLCompositeType typeCondition = (GraphQLCompositeType)this.schema.getType(fragmentDefinition.getTypeCondition().getName());
        Assert.assertNotNull(typeCondition, () -> String.format("Invalid type condition '%s' in fragment '%s'", fragmentDefinition.getTypeCondition().getName(), fragmentDefinition.getName()));
        context.setVar(QueryTraversalContext.class, new QueryTraversalContext(typeCondition, parentEnv.getEnvironment(), fragmentDefinition, graphQLContext));
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitField(Field field, TraverserContext<Node> context) {
        QueryTraversalContext parentEnv = context.getVarFromParents(QueryTraversalContext.class);
        GraphQLContext graphQLContext = parentEnv.getGraphQLContext();
        GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(this.schema, (GraphQLCompositeType)((Object)GraphQLTypeUtil.unwrapAll(parentEnv.getOutputType())), field.getName());
        boolean isTypeNameIntrospectionField = fieldDefinition == this.schema.getIntrospectionTypenameFieldDefinition();
        GraphQLFieldsContainer fieldsContainer = !isTypeNameIntrospectionField ? (GraphQLFieldsContainer)((Object)GraphQLTypeUtil.unwrapAll(parentEnv.getOutputType())) : null;
        GraphQLCodeRegistry codeRegistry = this.schema.getCodeRegistry();
        Map<String, Object> argumentValues = ValuesResolver.getArgumentValues(codeRegistry, fieldDefinition.getArguments(), field.getArguments(), CoercedVariables.of(this.variables), GraphQLContext.getDefault(), Locale.getDefault());
        QueryVisitorFieldEnvironmentImpl environment = new QueryVisitorFieldEnvironmentImpl(isTypeNameIntrospectionField, field, fieldDefinition, parentEnv.getOutputType(), fieldsContainer, parentEnv.getEnvironment(), argumentValues, parentEnv.getSelectionSetContainer(), context, this.schema);
        if (context.getPhase() == TraverserContext.Phase.LEAVE) {
            this.postOrderCallback.visitField(environment);
            return TraversalControl.CONTINUE;
        }
        if (!this.conditionalNodes.shouldInclude(field, this.variables, null, graphQLContext)) {
            return TraversalControl.ABORT;
        }
        TraversalControl traversalControl = this.preOrderCallback.visitFieldWithControl(environment);
        GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll(fieldDefinition.getType());
        QueryTraversalContext fieldEnv = unmodifiedType instanceof GraphQLCompositeType ? new QueryTraversalContext(fieldDefinition.getType(), environment, field, graphQLContext) : new QueryTraversalContext(null, environment, field, graphQLContext);
        context.setVar(QueryTraversalContext.class, fieldEnv);
        return traversalControl;
    }

    @Override
    public TraversalControl visitArgument(Argument argument, TraverserContext<Node> context) {
        QueryTraversalContext fieldCtx = context.getVarFromParents(QueryTraversalContext.class);
        Field field = (Field)fieldCtx.getSelectionSetContainer();
        QueryVisitorFieldEnvironment fieldEnv = fieldCtx.getEnvironment();
        GraphQLFieldsContainer fieldsContainer = fieldEnv.getFieldsContainer();
        GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(this.schema, fieldsContainer, field.getName());
        GraphQLArgument graphQLArgument = fieldDefinition.getArgument(argument.getName());
        String argumentName = graphQLArgument.getName();
        Object argumentValue = fieldEnv.getArguments().getOrDefault(argumentName, null);
        QueryVisitorFieldArgumentEnvironmentImpl environment = new QueryVisitorFieldArgumentEnvironmentImpl(fieldDefinition, argument, graphQLArgument, argumentValue, this.variables, fieldEnv, context, this.schema);
        QueryVisitorFieldArgumentInputValue inputValue = QueryVisitorFieldArgumentInputValueImpl.incompleteArgumentInputValue(graphQLArgument);
        context.setVar(QueryVisitorFieldArgumentEnvironment.class, environment);
        context.setVar(QueryVisitorFieldArgumentInputValue.class, inputValue);
        if (context.getPhase() == TraverserContext.Phase.LEAVE) {
            return this.postOrderCallback.visitArgument(environment);
        }
        return this.preOrderCallback.visitArgument(environment);
    }

    @Override
    public TraversalControl visitObjectField(ObjectField node, TraverserContext<Node> context) {
        QueryVisitorFieldArgumentInputValueImpl inputValue = (QueryVisitorFieldArgumentInputValueImpl)context.getVarFromParents(QueryVisitorFieldArgumentInputValue.class);
        GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll(inputValue.getInputType());
        if (unmodifiedType instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)unmodifiedType;
            GraphQLInputObjectField inputObjectTypeField = inputObjectType.getField(node.getName());
            inputValue = inputValue.incompleteNewChild(inputObjectTypeField);
            context.setVar(QueryVisitorFieldArgumentInputValue.class, inputValue);
        }
        return TraversalControl.CONTINUE;
    }

    @Override
    protected TraversalControl visitValue(Value<?> value, TraverserContext<Node> context) {
        if (context.getParentNode() instanceof VariableDefinition) {
            this.visitVariableDefinition((VariableDefinition)context.getParentNode(), context);
            return TraversalControl.ABORT;
        }
        QueryVisitorFieldArgumentEnvironment fieldArgEnv = context.getVarFromParents(QueryVisitorFieldArgumentEnvironment.class);
        QueryVisitorFieldArgumentInputValueImpl inputValue = (QueryVisitorFieldArgumentInputValueImpl)context.getVarFromParents(QueryVisitorFieldArgumentInputValue.class);
        inputValue = inputValue.completeArgumentInputValue(value);
        context.setVar(QueryVisitorFieldArgumentInputValue.class, inputValue);
        QueryVisitorFieldArgumentValueEnvironmentImpl environment = new QueryVisitorFieldArgumentValueEnvironmentImpl(this.schema, fieldArgEnv.getFieldDefinition(), fieldArgEnv.getGraphQLArgument(), inputValue, context, this.variables);
        if (context.getPhase() == TraverserContext.Phase.LEAVE) {
            return this.postOrderCallback.visitArgumentValue(environment);
        }
        return this.preOrderCallback.visitArgumentValue(environment);
    }
}

