/*
 * Decompiled with CFR 0.152.
 */
package graphql.collect;

import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Internal
public final class ImmutableKit {
    public static <T> ImmutableList<T> emptyList() {
        return ImmutableList.of();
    }

    public static <T> ImmutableList<T> nonNullCopyOf(Collection<T> collection) {
        return collection == null ? ImmutableKit.emptyList() : ImmutableList.copyOf(collection);
    }

    public static <K, V> ImmutableMap<K, V> emptyMap() {
        return ImmutableMap.of();
    }

    public static <K, V> ImmutableMap<K, V> addToMap(Map<K, V> existing, K newKey, V newVal) {
        return ImmutableMap.builder().putAll(existing).put(newKey, newVal).build();
    }

    public static <T> ImmutableList<T> concatLists(List<T> l1, List<T> l2) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builderWithExpectedSize(l1.size() + l2.size()).addAll(l1)).addAll(l2)).build();
    }

    public static <T, R> ImmutableList<R> map(Collection<? extends T> collection, Function<? super T, ? extends R> mapper) {
        Assert.assertNotNull(collection);
        Assert.assertNotNull(mapper);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(collection.size());
        for (T t : collection) {
            R r = mapper.apply(t);
            builder.add(r);
        }
        return builder.build();
    }

    public static <T, R> ImmutableList<R> mapAndDropNulls(Collection<? extends T> collection, Function<? super T, ? extends R> mapper) {
        Assert.assertNotNull(collection);
        Assert.assertNotNull(mapper);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(collection.size());
        for (T t : collection) {
            R r = mapper.apply(t);
            if (r == null) continue;
            builder.add(r);
        }
        return builder.build();
    }

    @SafeVarargs
    public static <T> ImmutableList<T> addToList(Collection<? extends T> existing, T newValue, T ... extraValues) {
        Assert.assertNotNull(existing);
        Assert.assertNotNull(newValue);
        int expectedSize = existing.size() + 1 + extraValues.length;
        ImmutableList.Builder newList = ImmutableList.builderWithExpectedSize(expectedSize);
        newList.addAll(existing);
        newList.add(newValue);
        for (T extraValue : extraValues) {
            newList.add(extraValue);
        }
        return newList.build();
    }

    @SafeVarargs
    public static <T> ImmutableSet<T> addToSet(Collection<? extends T> existing, T newValue, T ... extraValues) {
        Assert.assertNotNull(existing);
        Assert.assertNotNull(newValue);
        int expectedSize = existing.size() + 1 + extraValues.length;
        ImmutableSet.Builder newSet = ImmutableSet.builderWithExpectedSize(expectedSize);
        newSet.addAll(existing);
        newSet.add(newValue);
        for (T extraValue : extraValues) {
            newSet.add(extraValue);
        }
        return newSet.build();
    }
}

