/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener;

import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppResourcePerf;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserResourcePerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataAnalysisListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataListenerFactory;

public class BrowserWebResourcePerfDataAnalysisListener
implements PerfDataAnalysisListener<BrowserResourcePerfDataDecorator> {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;
    private BrowserAppResourcePerf browserAppResourcePerf;

    public BrowserWebResourcePerfDataAnalysisListener(SourceReceiver sourceReceiver, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.namingControl = namingControl;
    }

    @Override
    public void build() {
        this.sourceReceiver.receive((ISource)this.browserAppResourcePerf);
    }

    @Override
    public void parse(BrowserResourcePerfDataDecorator decorator) {
        this.browserAppResourcePerf = new BrowserAppResourcePerf();
        this.browserAppResourcePerf.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)decorator.getTime()));
        this.browserAppResourcePerf.setServiceName(this.namingControl.formatServiceName(decorator.getService()));
        this.browserAppResourcePerf.setPath(this.namingControl.formatEndpointName(this.browserAppResourcePerf.getServiceName(), decorator.getPagePath()));
        this.browserAppResourcePerf.setName(decorator.getName());
        this.browserAppResourcePerf.setDuration(decorator.getDuration());
        this.browserAppResourcePerf.setSize(decorator.getSize());
        this.browserAppResourcePerf.setProtocol(decorator.getProtocol());
        this.browserAppResourcePerf.setType(decorator.getType());
    }

    public static class Factory
    implements PerfDataListenerFactory<BrowserResourcePerfDataDecorator> {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public PerfDataAnalysisListener<BrowserResourcePerfDataDecorator> create(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            return new BrowserWebResourcePerfDataAnalysisListener(this.sourceReceiver, this.namingControl);
        }
    }
}

