/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc.protocol;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DecoratingClientFactory;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.grpc.protocol.UnaryGrpcClient;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.common.grpc.protocol.UnaryGrpcSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;

final class UnaryGrpcClientFactory
extends DecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES = (Set)Arrays.stream(SessionProtocol.values()).flatMap(p -> UnaryGrpcSerializationFormats.values().stream().map(f -> Scheme.of((SerializationFormat)f, (SessionProtocol)p))).collect(ImmutableSet.toImmutableSet());

    UnaryGrpcClientFactory(ClientFactory httpClientFactory) {
        super(httpClientFactory);
    }

    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public boolean isClientTypeSupported(Class<?> clientType) {
        return clientType == UnaryGrpcClient.class;
    }

    public Object newClient(ClientBuilderParams params) {
        Scheme scheme = params.scheme();
        SerializationFormat serializationFormat = scheme.serializationFormat();
        ClientBuilderParams newParams = ClientBuilderParams.of((Scheme)Scheme.of((SerializationFormat)SerializationFormat.NONE, (SessionProtocol)scheme.sessionProtocol()), (EndpointGroup)params.endpointGroup(), (String)params.absolutePathRef(), WebClient.class, (ClientOptions)params.options());
        WebClient webClient = (WebClient)((ClientFactory)this.unwrap()).newClient(newParams);
        return new UnaryGrpcClient(webClient, serializationFormat);
    }
}

