/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.common;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.MediaType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.factory.BulkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonBulkFactory
implements BulkFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonBulkFactory.class);
    private final ElasticSearchVersion version;

    @Override
    public HttpRequest bulk(ByteBuf content) {
        Objects.requireNonNull(content, "content");
        if (log.isDebugEnabled()) {
            log.debug("Bulk requests: {}", (Object)content.toString(StandardCharsets.UTF_8));
        }
        return HttpRequest.builder().post("/_bulk").content(MediaType.JSON, HttpData.wrap((ByteBuf)content)).build();
    }

    @Generated
    public CommonBulkFactory(ElasticSearchVersion version) {
        this.version = version;
    }
}

