/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type.debugging;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;

public class DebuggingTrace {
    private final String traceId;
    private final String condition;
    private final long startTime;
    private long endTime;
    private long duration;
    private final List<DebuggingSpan> spans = new ArrayList<DebuggingSpan>();

    public DebuggingTrace(String condition) {
        this.condition = condition;
        this.traceId = UUID.randomUUID().toString();
        this.startTime = System.nanoTime();
    }

    public void addSpan(DebuggingSpan span) {
        this.spans.add(span);
    }

    public void stopTrace() {
        this.endTime = System.nanoTime();
        this.duration = this.endTime - this.startTime;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public String getCondition() {
        return this.condition;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public List<DebuggingSpan> getSpans() {
        return this.spans;
    }
}

