/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type.debugging;

import java.util.Stack;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTrace;

public class DebuggingTraceContext {
    public static final ThreadLocal<DebuggingTraceContext> TRACE_CONTEXT = new ThreadLocal();
    private final DebuggingTrace execTrace;
    private final Stack<DebuggingSpan> spanStack = new Stack();
    private int spanIdGenerator;
    private final boolean debug;
    private final boolean dumpStorageRsp;

    public DebuggingTraceContext(String condition, boolean debug, boolean dumpStorageRsp) {
        this.execTrace = new DebuggingTrace(condition);
        this.debug = debug;
        this.dumpStorageRsp = dumpStorageRsp;
    }

    public DebuggingSpan createSpan(String operation) {
        DebuggingSpan span = new DebuggingSpan(this.spanIdGenerator++, operation);
        if (this.debug) {
            DebuggingSpan parentSpan;
            span.setStartTime(System.nanoTime());
            DebuggingSpan debuggingSpan = parentSpan = this.spanStack.isEmpty() ? null : this.spanStack.peek();
            if (parentSpan != null) {
                span.setParentSpanId(parentSpan.getSpanId());
            } else {
                span.setParentSpanId(-1);
            }
            this.spanStack.push(span);
            this.execTrace.addSpan(span);
        }
        return span;
    }

    public DebuggingSpan createSpanForTransform(String operation) {
        DebuggingSpan span = new DebuggingSpan(this.spanIdGenerator++, operation);
        if (this.debug) {
            this.execTrace.addSpan(span);
        }
        return span;
    }

    public DebuggingSpan getParentSpan() {
        if (this.spanStack.isEmpty()) {
            return null;
        }
        return this.spanStack.peek();
    }

    public void stopSpan(DebuggingSpan span) {
        if (this.debug) {
            span.setEndTime(System.nanoTime());
            span.setDuration(span.getEndTime() - span.getStartTime());
            if (this.spanStack.isEmpty()) {
                return;
            }
            this.spanStack.pop();
        }
    }

    public void stopTrace() {
        if (this.debug) {
            this.execTrace.stopTrace();
        }
    }

    @Generated
    public DebuggingTrace getExecTrace() {
        return this.execTrace;
    }

    @Generated
    public Stack<DebuggingSpan> getSpanStack() {
        return this.spanStack;
    }

    @Generated
    public int getSpanIdGenerator() {
        return this.spanIdGenerator;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public boolean isDumpStorageRsp() {
        return this.dumpStorageRsp;
    }
}

