/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.debug;

import com.google.gson.Gson;
import io.grpc.Channel;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmRulesWatcherService;
import org.apache.skywalking.oap.server.core.alarm.AlarmStatusWatcherService;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.status.AlarmRuleDetail;
import org.apache.skywalking.oap.server.core.alarm.provider.status.AlarmRuleList;
import org.apache.skywalking.oap.server.core.alarm.provider.status.AlarmRunningContext;
import org.apache.skywalking.oap.server.core.alarm.provider.status.ClusterAlarmStatus;
import org.apache.skywalking.oap.server.core.alarm.provider.status.InstanceAlarmStatus;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager;
import org.apache.skywalking.oap.server.core.remote.client.SelfRemoteClient;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.AlarmRequest;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteServiceGrpc;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.StatusRequest;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.StatusResponse;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmStatusQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmStatusQueryService.class);
    private final ModuleManager moduleManager;
    private static final Gson GSON = new Gson();
    private AlarmRulesWatcher alarmRulesWatcher;
    private AlarmStatusWatcherService alarmStatusWatcher;
    private RemoteClientManager remoteClientManager;

    public AlarmStatusQueryService(ModuleManager manager) {
        this.moduleManager = manager;
    }

    private AlarmRulesWatcher getAlarmRulesWatcher() {
        if (this.alarmRulesWatcher == null) {
            this.alarmRulesWatcher = (AlarmRulesWatcher)this.moduleManager.find("alarm").provider().getService(AlarmRulesWatcherService.class);
        }
        return this.alarmRulesWatcher;
    }

    private AlarmStatusWatcherService getAlarmStatusWatcher() {
        if (this.alarmStatusWatcher == null) {
            this.alarmStatusWatcher = (AlarmStatusWatcherService)this.moduleManager.find("alarm").provider().getService(AlarmStatusWatcherService.class);
        }
        return this.alarmStatusWatcher;
    }

    private RemoteClientManager getRemoteClientManager() {
        if (this.remoteClientManager == null) {
            this.remoteClientManager = (RemoteClientManager)this.moduleManager.find("core").provider().getService(RemoteClientManager.class);
        }
        return this.remoteClientManager;
    }

    public ClusterAlarmStatus<InstanceAlarmStatus<AlarmRuleList>> getAlarmRules() {
        ClusterAlarmStatus result = new ClusterAlarmStatus();
        List list = this.getRemoteClientManager().getRemoteClient();
        for (RemoteClient remoteClient : list) {
            String rulesInfo = null;
            String errorMsg = null;
            try {
                if (remoteClient instanceof SelfRemoteClient) {
                    rulesInfo = this.getAlarmStatusWatcher().getAlarmRules();
                } else {
                    RemoteServiceGrpc.RemoteServiceBlockingStub stub = RemoteServiceGrpc.newBlockingStub((Channel)remoteClient.getChannel());
                    AlarmRequest alarmRequest = AlarmRequest.newBuilder().setRequestType(AlarmRequest.RequestType.GET_ALARM_RULES).build();
                    StatusResponse statusResponse = stub.syncStatus(StatusRequest.newBuilder().setAlarmRequest(alarmRequest).build());
                    rulesInfo = statusResponse.getAlarmStatus();
                }
            }
            catch (Exception e) {
                log.warn("Failed to get alarm rule list.", (Throwable)e);
                errorMsg = e.getMessage();
            }
            AlarmRuleList alarmRuleList = (AlarmRuleList)GSON.fromJson(rulesInfo, AlarmRuleList.class);
            InstanceAlarmStatus instanceAlarmStatus = new InstanceAlarmStatus();
            instanceAlarmStatus.setStatus((Object)alarmRuleList);
            instanceAlarmStatus.setAddress(remoteClient.getAddress().toString());
            instanceAlarmStatus.setErrorMsg(errorMsg);
            result.getOapInstances().add(instanceAlarmStatus);
        }
        return result;
    }

    public ClusterAlarmStatus<InstanceAlarmStatus<AlarmRuleDetail>> getAlarmRuleById(String ruleId) {
        ClusterAlarmStatus result = new ClusterAlarmStatus();
        List list = this.getRemoteClientManager().getRemoteClient();
        for (RemoteClient remoteClient : list) {
            String ruleDetail = null;
            String errorMsg = null;
            try {
                if (remoteClient instanceof SelfRemoteClient) {
                    ruleDetail = this.getAlarmStatusWatcher().getAlarmRuleById(ruleId);
                } else {
                    RemoteServiceGrpc.RemoteServiceBlockingStub stub = RemoteServiceGrpc.newBlockingStub((Channel)remoteClient.getChannel());
                    AlarmRequest alarmRequest = AlarmRequest.newBuilder().setRequestType(AlarmRequest.RequestType.GET_ALARM_RULE_BY_ID).setRuleId(ruleId).build();
                    StatusResponse statusResponse = stub.syncStatus(StatusRequest.newBuilder().setAlarmRequest(alarmRequest).build());
                    ruleDetail = statusResponse.getAlarmStatus();
                }
            }
            catch (Exception e) {
                log.warn("Failed to get alarm rule detail by ID: {}.", (Object)ruleId, (Object)e);
                errorMsg = e.getMessage();
            }
            AlarmRuleDetail alarmRuleDetail = (AlarmRuleDetail)GSON.fromJson(ruleDetail, AlarmRuleDetail.class);
            InstanceAlarmStatus instanceAlarmRuleDetail = new InstanceAlarmStatus();
            instanceAlarmRuleDetail.setStatus((Object)alarmRuleDetail);
            instanceAlarmRuleDetail.setAddress(remoteClient.getAddress().toString());
            instanceAlarmRuleDetail.setErrorMsg(errorMsg);
            result.getOapInstances().add(instanceAlarmRuleDetail);
        }
        return result;
    }

    public ClusterAlarmStatus<InstanceAlarmStatus<AlarmRunningContext>> getAlarmRuleContext(String ruleId, String entityName) {
        ClusterAlarmStatus result = new ClusterAlarmStatus();
        List list = this.getRemoteClientManager().getRemoteClient();
        for (RemoteClient remoteClient : list) {
            String context = null;
            String errorMsg = null;
            try {
                if (remoteClient instanceof SelfRemoteClient) {
                    context = this.getAlarmStatusWatcher().getAlarmRuleContext(ruleId, entityName);
                } else {
                    RemoteServiceGrpc.RemoteServiceBlockingStub stub = RemoteServiceGrpc.newBlockingStub((Channel)remoteClient.getChannel());
                    AlarmRequest alarmRequest = AlarmRequest.newBuilder().setRequestType(AlarmRequest.RequestType.GET_ALARM_RULE_CONTEXT).setRuleId(ruleId).setEntityName(entityName).build();
                    StatusResponse statusResponse = stub.syncStatus(StatusRequest.newBuilder().setAlarmRequest(alarmRequest).build());
                    context = statusResponse.getAlarmStatus();
                }
            }
            catch (Exception e) {
                log.warn("Failed to get alarm running context by ruleId: {} and entityName: {}.", new Object[]{ruleId, entityName, e});
                errorMsg = e.getMessage();
            }
            AlarmRunningContext alarmRunningContext = (AlarmRunningContext)GSON.fromJson(context, AlarmRunningContext.class);
            InstanceAlarmStatus runningContext = new InstanceAlarmStatus();
            runningContext.setStatus((Object)alarmRunningContext);
            runningContext.setAddress(remoteClient.getAddress().toString());
            runningContext.setErrorMsg(errorMsg);
            result.getOapInstances().add(runningContext);
        }
        return result;
    }
}

