/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.cilium.nodes;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import java.io.File;
import java.net.URI;
import lombok.Generated;
import org.apache.skywalking.oap.server.fetcher.cilium.CiliumFetcherConfig;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.ClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcStubBuilder
implements ClientBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcStubBuilder.class);
    private final CiliumFetcherConfig config;
    private final ClientFactory clientFactory;

    public GrpcStubBuilder(CiliumFetcherConfig config) {
        ClientFactoryBuilder builder = ClientFactory.builder();
        if (config.isSslConnection()) {
            builder.tlsNoVerify().useHttp2WithoutAlpn(true).tlsCustomizer(ctx -> {
                ctx.keyManager(new File(config.getSslCertChainFile()), new File(config.getSslPrivateKeyFile()));
                ctx.trustManager(new File(config.getSslCaFile()));
            });
        }
        this.config = config;
        this.clientFactory = builder.build();
    }

    @Override
    public <T> T buildClient(String host, int port, Class<T> stubClass) {
        String proto = "http";
        if (this.config.isSslConnection()) {
            proto = "https";
        }
        URI url = new URI("gproto+" + proto, null, host, port, "/", null, null);
        return (T)this.clientFactory.newClient(ClientBuilderParams.of((URI)url, stubClass, (ClientOptions)ClientOptions.of((ClientOptionValue[])new ClientOptionValue[]{(ClientOptionValue)ClientOptions.RESPONSE_TIMEOUT_MILLIS.newValue((Object)Long.MAX_VALUE), (ClientOptionValue)ClientOptions.MAX_RESPONSE_LENGTH.newValue((Object)0L)})));
    }
}

