/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.query.graphql.type.TimeInfo;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.TTLStatusQuery;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.ServiceCondition;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.EndpointInfo;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.ttl.MetricsTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.RecordsTTL;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetadataQueryV2
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private MetadataQueryService metadataQueryService;
    private TTLStatusQuery ttlStatusQuery;

    public MetadataQueryV2(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private MetadataQueryService getMetadataQueryService() {
        if (this.metadataQueryService == null) {
            this.metadataQueryService = (MetadataQueryService)this.moduleManager.find("core").provider().getService(MetadataQueryService.class);
        }
        return this.metadataQueryService;
    }

    private TTLStatusQuery getTTLStatusQuery() {
        if (this.ttlStatusQuery == null) {
            this.ttlStatusQuery = (TTLStatusQuery)this.moduleManager.find("core").provider().getService(TTLStatusQuery.class);
        }
        return this.ttlStatusQuery;
    }

    public CompletableFuture<Set<String>> listLayers() {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().listLayers());
    }

    public CompletableFuture<List<Service>> listServices(String layer) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().listServices(layer, null));
    }

    public CompletableFuture<Service> findService(String serviceName) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().getService(IDManager.ServiceID.buildId((String)serviceName, (boolean)true)));
    }

    public CompletableFuture<Service> getService(String serviceId) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().getService(serviceId));
    }

    public CompletableFuture<List<ServiceInstance>> listInstances(Duration duration, String serviceId) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().listInstances(duration, serviceId));
    }

    public CompletableFuture<List<ServiceInstance>> listInstancesByName(Duration duration, ServiceCondition service) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().listInstances(duration, service.getServiceId()));
    }

    public CompletableFuture<ServiceInstance> getInstance(String instanceId) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().getInstance(instanceId));
    }

    public CompletableFuture<List<Endpoint>> findEndpoint(String keyword, String serviceId, int limit, Duration duration) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().findEndpoint(keyword, serviceId, limit, duration));
    }

    public CompletableFuture<List<Endpoint>> findEndpointByName(String keyword, ServiceCondition service, int limit, Duration duration) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().findEndpoint(keyword, service.getServiceId(), limit, duration));
    }

    public CompletableFuture<EndpointInfo> getEndpointInfo(String endpointId) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().getEndpointInfo(endpointId));
    }

    public CompletableFuture<List<Process>> listProcesses(Duration duration, String instanceId) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().listProcesses(duration, instanceId));
    }

    public CompletableFuture<Process> getProcess(String processId) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().getProcess(processId));
    }

    public CompletableFuture<Long> estimateProcessScale(String serviceId, List<String> labels) {
        return AsyncQueryUtils.queryAsync(() -> this.getMetadataQueryService().estimateProcessScale(serviceId, labels));
    }

    public TimeInfo getTimeInfo() {
        TimeInfo timeInfo = new TimeInfo();
        SimpleDateFormat timezoneFormat = new SimpleDateFormat("ZZZZZZ");
        Date date = new Date();
        timeInfo.setCurrentTimestamp(date.getTime());
        timeInfo.setTimezone(timezoneFormat.format(date));
        return timeInfo;
    }

    public RecordsTTL getRecordsTTL() {
        return this.getTTLStatusQuery().getTTL().getRecords();
    }

    public MetricsTTL getMetricsTTL() {
        return this.getTTLStatusQuery().getTTL().getMetrics();
    }
}

