/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.ArrayList;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.meter.BaseMeter;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterService;
import org.apache.skywalking.apm.agent.core.meter.MeterTag;
import org.apache.skywalking.apm.agent.core.meter.MeterType;

public abstract class AbstractBuilder<BUILDER extends AbstractBuilder, METER extends BaseMeter> {
    private static MeterService METER_SERVICE;
    protected final MeterId meterId;

    public AbstractBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Meter name cannot be null");
        }
        this.meterId = new MeterId(name, this.getType(), new ArrayList<MeterTag>());
    }

    public BUILDER tag(String name, String value) {
        this.meterId.getTags().add(new MeterTag(name, value));
        return (BUILDER)this;
    }

    protected abstract MeterType getType();

    protected abstract METER create(MeterId var1);

    public METER build() {
        this.meterId.getTags().sort(MeterTag::compareTo);
        if (METER_SERVICE == null) {
            METER_SERVICE = ServiceManager.INSTANCE.findService(MeterService.class);
        }
        METER adapter = this.create(this.meterId);
        METER_SERVICE.register(adapter);
        return adapter;
    }
}

