/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.network.TransferableChannel;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.ConvertedRecords;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.DefaultRecordsSend;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.LazyDownConversionRecords;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.MemoryRecords;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.RecordValidationStats;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.RecordsSend;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

public final class LazyDownConversionRecordsSend
extends RecordsSend<LazyDownConversionRecords> {
    private static final Logger log = LoggerFactory.getLogger(LazyDownConversionRecordsSend.class);
    private static final int MAX_READ_SIZE = 131072;
    static final int MIN_OVERFLOW_MESSAGE_LENGTH = 12;
    private final RecordValidationStats recordValidationStats = new RecordValidationStats();
    private final Iterator<ConvertedRecords<?>> convertedRecordsIterator = ((LazyDownConversionRecords)this.records()).iterator(131072L);
    private RecordsSend<MemoryRecords> convertedRecordsWriter = null;

    public LazyDownConversionRecordsSend(LazyDownConversionRecords records) {
        super(records, records.sizeInBytes());
    }

    private MemoryRecords buildOverflowBatch(int remaining) {
        ByteBuffer overflowMessageBatch = ByteBuffer.allocate(Math.max(12, Math.min(remaining + 1, 131072)));
        overflowMessageBatch.putLong(-1L);
        overflowMessageBatch.putInt(Math.max(remaining + 1, 61));
        log.debug("Constructed overflow message batch for partition {} with length={}", (Object)this.topicPartition(), (Object)remaining);
        return MemoryRecords.readableRecords(overflowMessageBatch);
    }

    @Override
    public int writeTo(TransferableChannel channel, int previouslyWritten, int remaining) throws IOException {
        if (this.convertedRecordsWriter == null || this.convertedRecordsWriter.completed()) {
            MemoryRecords convertedRecords;
            try {
                if (this.convertedRecordsIterator.hasNext()) {
                    ConvertedRecords<?> recordsAndStats = this.convertedRecordsIterator.next();
                    convertedRecords = (MemoryRecords)recordsAndStats.records();
                    this.recordValidationStats.add(recordsAndStats.recordConversionStats());
                    log.debug("Down-converted records for partition {} with length={}", (Object)this.topicPartition(), (Object)convertedRecords.sizeInBytes());
                } else {
                    convertedRecords = this.buildOverflowBatch(remaining);
                }
            }
            catch (UnsupportedCompressionTypeException e) {
                convertedRecords = this.buildOverflowBatch(remaining);
            }
            this.convertedRecordsWriter = new DefaultRecordsSend<MemoryRecords>(convertedRecords, Math.min(convertedRecords.sizeInBytes(), remaining));
        }
        return (int)this.convertedRecordsWriter.writeTo(channel);
    }

    public RecordValidationStats recordConversionStats() {
        return this.recordValidationStats;
    }

    public TopicPartition topicPartition() {
        return ((LazyDownConversionRecords)this.records()).topicPartition();
    }
}

