/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.guard;

import java.lang.reflect.Constructor;
import net.sf.oval.guard.Guard;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Invocable;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class GuardInterceptor
implements MethodInterceptor,
ConstructorInterceptor {
    private static final Log LOG = Log.getLog(GuardInterceptor.class);
    private Guard guard;

    public GuardInterceptor() {
        this(new Guard());
    }

    public GuardInterceptor(Guard guard) {
        LOG.info("Instantiated");
        this.setGuard(guard);
    }

    public Object construct(ConstructorInvocation constructorInvocation) throws Throwable {
        Constructor ctor = constructorInvocation.getConstructor();
        Object[] args = constructorInvocation.getArguments();
        Object target = constructorInvocation.getThis();
        this.guard.guardConstructorPre(target, ctor, args);
        Object result = constructorInvocation.proceed();
        this.guard.guardConstructorPost(target, ctor, args);
        return result;
    }

    public Guard getGuard() {
        return this.guard;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        return this.guard.guardMethod(methodInvocation.getThis(), methodInvocation.getMethod(), methodInvocation.getArguments(), new MethodInvocable(methodInvocation));
    }

    public void setGuard(Guard guard) {
        this.guard = guard;
    }

    protected static final class MethodInvocable
    implements Invocable {
        private final MethodInvocation methodInvocation;

        protected MethodInvocable(MethodInvocation methodInvocation) {
            this.methodInvocation = methodInvocation;
        }

        public Object invoke() throws Throwable {
            return this.methodInvocation.proceed();
        }
    }
}

