/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class MockMultipartHttpServletRequestBuilder
extends MockHttpServletRequestBuilder {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();
    private final MultiValueMap<String, Part> parts = new LinkedMultiValueMap();

    MockMultipartHttpServletRequestBuilder(String urlTemplate, Object ... uriVariables) {
        this(HttpMethod.POST, urlTemplate, uriVariables);
    }

    MockMultipartHttpServletRequestBuilder(HttpMethod httpMethod, String urlTemplate, Object ... uriVariables) {
        super(httpMethod, urlTemplate, uriVariables);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    MockMultipartHttpServletRequestBuilder(URI uri) {
        this(HttpMethod.POST, uri);
    }

    MockMultipartHttpServletRequestBuilder(HttpMethod httpMethod, URI uri) {
        super(httpMethod, uri);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public MockMultipartHttpServletRequestBuilder file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return this;
    }

    public MockMultipartHttpServletRequestBuilder file(MockMultipartFile file) {
        this.files.add(file);
        return this;
    }

    public MockMultipartHttpServletRequestBuilder part(Part ... parts) {
        Assert.notEmpty((Object[])parts, (String)"'parts' must not be empty");
        for (Part part : parts) {
            this.parts.add((Object)part.getName(), (Object)part);
        }
        return this;
    }

    @Override
    public Object merge(@Nullable Object parent) {
        if (parent == null) {
            return this;
        }
        if (parent instanceof MockHttpServletRequestBuilder) {
            super.merge(parent);
            if (parent instanceof MockMultipartHttpServletRequestBuilder) {
                MockMultipartHttpServletRequestBuilder parentBuilder = (MockMultipartHttpServletRequestBuilder)parent;
                this.files.addAll(parentBuilder.files);
                parentBuilder.parts.keySet().forEach(name -> this.parts.putIfAbsent(name, (Object)((List)parentBuilder.parts.get(name))));
            }
        } else {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        return this;
    }

    @Override
    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request2 = new MockMultipartHttpServletRequest(servletContext);
        Charset defaultCharset = request2.getCharacterEncoding() != null ? Charset.forName(request2.getCharacterEncoding()) : StandardCharsets.UTF_8;
        this.files.forEach(request2::addFile);
        this.parts.values().stream().flatMap(Collection::stream).forEach(part -> {
            request2.addPart((Part)part);
            try {
                String name = part.getName();
                String filename = part.getSubmittedFileName();
                InputStream is = part.getInputStream();
                if (filename != null) {
                    request2.addFile(new MockMultipartFile(name, filename, part.getContentType(), is));
                } else {
                    InputStreamReader reader = new InputStreamReader(is, this.getCharsetOrDefault((Part)part, defaultCharset));
                    String value = FileCopyUtils.copyToString((Reader)reader);
                    request2.addParameter(part.getName(), value);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to read content for part " + part.getName(), ex);
            }
        });
        return request2;
    }

    private Charset getCharsetOrDefault(Part part, Charset defaultCharset) {
        MediaType mediaType;
        if (part.getContentType() != null && (mediaType = MediaType.parseMediaType((String)part.getContentType())).getCharset() != null) {
            return mediaType.getCharset();
        }
        return defaultCharset;
    }
}

