/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Properties;
import java.util.prefs.Preferences;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PreferencesPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private String systemTreePath;
    private String userTreePath;
    private Preferences systemPrefs;
    private Preferences userPrefs;

    public void setSystemTreePath(String systemTreePath) {
        this.systemTreePath = systemTreePath;
    }

    public void setUserTreePath(String userTreePath) {
        this.userTreePath = userTreePath;
    }

    public void afterPropertiesSet() {
        this.systemPrefs = this.systemTreePath != null ? Preferences.systemRoot().node(this.systemTreePath) : Preferences.systemRoot();
        this.userPrefs = this.userTreePath != null ? Preferences.userRoot().node(this.userTreePath) : Preferences.userRoot();
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = this.userPrefs.get(placeholder, null);
        if (value == null && (value = this.systemPrefs.get(placeholder, null)) == null) {
            value = props.getProperty(placeholder);
        }
        return value;
    }
}

