/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jacl;

import com.sun.script.jacl.JaclScriptEngineFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class JaclScriptEngine
extends AbstractScriptEngine {
    private ScriptEngineFactory factory;
    private static ThreadLocal<Interp> interpreters = new ThreadLocal();
    private static final String CONTEXT = "javax.script.ScriptContext";
    private static final /* synthetic */ Class class$java$lang$Integer;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$java$lang$Long;
    private static final /* synthetic */ Class class$java$lang$Double;
    private static final /* synthetic */ Class class$java$lang$Boolean;
    private static final /* synthetic */ Class class$java$lang$Float;
    private static final /* synthetic */ Class class$java$lang$Byte;
    private static final /* synthetic */ Class class$java$lang$Short;
    private static final /* synthetic */ Class class$java$lang$Character;
    private static final /* synthetic */ Class class$java$lang$Object;

    private static TclObject java2tcl(Interp interp, Object javaObj) throws TclException {
        Class cls;
        Class clazz = javaObj == null ? (class$java$lang$Object == null ? (class$java$lang$Object = JaclScriptEngine.class$("java.lang.Object")) : class$java$lang$Object) : (cls = javaObj.getClass());
        if (cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = JaclScriptEngine.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return TclInteger.newInstance((int)((Integer)javaObj));
        }
        if (cls == (class$java$lang$Long == null ? (class$java$lang$Long = JaclScriptEngine.class$("java.lang.Long")) : class$java$lang$Long)) {
            return TclString.newInstance((String)javaObj.toString());
        }
        if (cls == (class$java$lang$Short == null ? (class$java$lang$Short = JaclScriptEngine.class$("java.lang.Short")) : class$java$lang$Short)) {
            return TclInteger.newInstance((int)((Short)javaObj).intValue());
        }
        if (cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = JaclScriptEngine.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return TclInteger.newInstance((int)((Byte)javaObj).intValue());
        }
        if (cls == (class$java$lang$Double == null ? (class$java$lang$Double = JaclScriptEngine.class$("java.lang.Double")) : class$java$lang$Double)) {
            return TclDouble.newInstance((double)((Double)javaObj));
        }
        if (cls == (class$java$lang$Float == null ? (class$java$lang$Float = JaclScriptEngine.class$("java.lang.Float")) : class$java$lang$Float)) {
            return TclDouble.newInstance((double)((Float)javaObj).doubleValue());
        }
        if (cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JaclScriptEngine.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return TclBoolean.newInstance((boolean)((Boolean)javaObj));
        }
        if (cls == (class$java$lang$Character == null ? (class$java$lang$Character = JaclScriptEngine.class$("java.lang.Character")) : class$java$lang$Character)) {
            return TclString.newInstance((String)((Character)javaObj).toString());
        }
        if (cls == (class$java$lang$String == null ? (class$java$lang$String = JaclScriptEngine.class$("java.lang.String")) : class$java$lang$String)) {
            return TclString.newInstance((String)((String)javaObj));
        }
        return ReflectObject.newInstance((Interp)interp, (Class)cls, (Object)javaObj);
    }

    private static Object tcl2java(Interp interp, TclObject tclObj) throws TclException {
        Object javaObject = null;
        boolean isReflectObj = false;
        try {
            javaObject = ReflectObject.get((Interp)interp, (TclObject)tclObj);
            isReflectObj = true;
        }
        catch (TclException e) {
            interp.resetResult();
        }
        if (isReflectObj) {
            return javaObject;
        }
        InternalRep rep = tclObj.getInternalRep();
        if (rep instanceof TclBoolean) {
            return new Boolean(TclBoolean.get((Interp)interp, (TclObject)tclObj));
        }
        if (rep instanceof TclInteger) {
            return new Integer(TclInteger.get((Interp)interp, (TclObject)tclObj));
        }
        if (rep instanceof TclDouble) {
            return new Double(TclDouble.get((Interp)interp, (TclObject)tclObj));
        }
        if (rep instanceof TclString) {
            return tclObj.toString();
        }
        return tclObj;
    }

    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        Interp interp = this.getInterp();
        AssocData oldAssocData = interp.getAssocData(CONTEXT);
        try {
            interp.setAssocData(CONTEXT, (AssocData)new ContextData(ctx));
            ctx.setAttribute("context", ctx, 100);
            interp.eval(str);
            TclObject tclObject = interp.getResult();
            return tclObject;
        }
        catch (TclException exp) {
            String errMsg = interp.getResult().toString();
            ScriptException se = new ScriptException(errMsg);
            se.initCause(exp);
            throw se;
        }
        finally {
            if (oldAssocData != null) {
                interp.setAssocData(CONTEXT, oldAssocData);
            }
        }
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        JaclScriptEngine jaclScriptEngine = this;
        synchronized (jaclScriptEngine) {
            if (this.factory == null) {
                this.factory = new JaclScriptEngineFactory();
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private Interp getInterp() {
        Interp interp = interpreters.get();
        if (interp == null) {
            interp = new Interp();
            ContextCommand cmd = new ContextCommand(null);
            interp.createCommand("context", (Command)cmd);
            interp.createCommand("var", (Command)cmd);
            interp.createCommand("echo", (Command)new EchoCommand(null));
            interpreters.set(interp);
        }
        return interp;
    }

    static TclObject access$000(Interp x0, Object x1) throws TclException {
        return JaclScriptEngine.java2tcl(x0, x1);
    }

    static Object access$100(Interp x0, TclObject x1) throws TclException {
        return JaclScriptEngine.tcl2java(x0, x1);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
    }

    private static class EchoCommand
    implements Command {
        private EchoCommand() {
        }

        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            Writer writer;
            AssocData data = interp.getAssocData(JaclScriptEngine.CONTEXT);
            if (data != null && data instanceof ContextData) {
                ScriptContext context = ((ContextData)data).getContext();
                writer = context.getWriter();
            } else {
                writer = new PrintWriter(System.out);
            }
            try {
                for (int i = 1; i < argv.length; ++i) {
                    writer.write(argv[i].toString());
                    writer.write(32);
                }
                writer.flush();
            }
            catch (IOException exp) {
                throw new TclException(interp, "I/O error: " + exp.getMessage());
            }
        }

        EchoCommand(1 x0) {
            this();
        }
    }

    private static class ContextCommand
    implements Command {
        private ContextCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getVariable(Interp interp, ScriptContext ctx, String name) throws TclException {
            ScriptContext scriptContext = ctx;
            synchronized (scriptContext) {
                int scope = ctx.getAttributesScope(name);
                if (scope == -1) {
                    throw new TclException(interp, "can't read \"" + name + "\": no such context variable");
                }
                Object val = ctx.getAttribute(name, scope);
                interp.setResult(JaclScriptEngine.access$000(interp, val));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setVariable(Interp interp, ScriptContext ctx, String name, TclObject value) throws TclException {
            ScriptContext scriptContext = ctx;
            synchronized (scriptContext) {
                int scope = ctx.getAttributesScope(name);
                if (scope == -1) {
                    scope = 100;
                }
                ctx.setAttribute(name, JaclScriptEngine.access$100(interp, value), scope);
                interp.setResult(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteVariable(Interp interp, ScriptContext ctx, String name) throws TclException {
            ScriptContext scriptContext = ctx;
            synchronized (scriptContext) {
                int scope = ctx.getAttributesScope(name);
                if (scope == -1) {
                    interp.setResult(false);
                } else {
                    ctx.removeAttribute(name, scope);
                    interp.setResult(true);
                }
            }
        }

        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            AssocData data = interp.getAssocData(JaclScriptEngine.CONTEXT);
            if (data != null && data instanceof ContextData) {
                ScriptContext context = ((ContextData)data).getContext();
                switch (argv.length) {
                    case 1: {
                        this.getVariable(interp, context, "context");
                        break;
                    }
                    case 2: {
                        this.getVariable(interp, context, argv[1].toString());
                        break;
                    }
                    case 3: {
                        String arg1 = argv[1].toString();
                        if (arg1.equals("-del")) {
                            String arg2 = argv[2].toString();
                            this.deleteVariable(interp, context, arg2);
                            break;
                        }
                        this.setVariable(interp, context, argv[1].toString(), argv[2]);
                        break;
                    }
                    default: {
                        throw new TclNumArgsException(interp, 1, argv, "?varName? ?-del? ?newValue?");
                    }
                }
            } else {
                throw new TclException(interp, "invalid script context");
            }
        }

        ContextCommand(1 x0) {
            this();
        }
    }

    private static class ContextData
    implements AssocData {
        private ScriptContext context;

        ContextData(ScriptContext ctx) {
            this.context = ctx;
        }

        ScriptContext getContext() {
            return this.context;
        }

        public void disposeAssocData(Interp interp) {
        }
    }
}

