/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMElementEx;
import org.apache.axiom.om.impl.builder.BuilderUtil;
import org.apache.axiom.om.impl.builder.OMFactoryEx;
import org.apache.axiom.om.impl.common.OMContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXOMBuilder
extends OMContentHandler
implements OMXMLParserWrapper {
    private final SAXSource source;
    private OMDocument document;
    private final OMFactoryEx factory;

    public SAXOMBuilder(OMFactory factory, SAXSource source, boolean expandEntityReferences) {
        super(expandEntityReferences);
        this.factory = (OMFactoryEx)factory;
        this.source = source;
    }

    protected OMContainer doStartDocument() {
        this.document = this.factory.createOMDocument((OMXMLParserWrapper)this);
        return this.document;
    }

    protected void doEndDocument() {
        ((OMContainerEx)this.document).setComplete(true);
    }

    public OMDocument getDocument() {
        if (this.document == null && this.source != null) {
            XMLReader reader = this.source.getXMLReader();
            reader.setContentHandler(this);
            reader.setDTDHandler(this);
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            }
            catch (SAXException sAXException) {}
            try {
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", this);
            }
            catch (SAXException sAXException) {}
            try {
                reader.parse(this.source.getInputSource());
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
            catch (SAXException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        if (this.document != null && this.document.isComplete()) {
            return this.document;
        }
        throw new OMException("Tree not complete");
    }

    public int next() throws OMException {
        throw new UnsupportedOperationException();
    }

    public void discard(OMElement el) throws OMException {
        throw new UnsupportedOperationException();
    }

    public void setCache(boolean b) throws OMException {
        throw new UnsupportedOperationException();
    }

    public boolean isCache() {
        throw new UnsupportedOperationException();
    }

    public Object getParser() {
        throw new UnsupportedOperationException();
    }

    public boolean isCompleted() {
        return this.document != null && this.document.isComplete();
    }

    public OMElement getDocumentElement() {
        return this.getDocument().getOMDocumentElement();
    }

    public OMElement getDocumentElement(boolean discardDocument) {
        OMElement documentElement = this.getDocument().getOMDocumentElement();
        if (discardDocument) {
            documentElement.detach();
        }
        return documentElement;
    }

    public short getBuilderType() {
        throw new UnsupportedOperationException();
    }

    public void registerExternalContentHandler(Object obj) {
        throw new UnsupportedOperationException();
    }

    public Object getRegisteredContentHandler() {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    protected void createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset) {
        this.factory.createOMDocType(parent, rootName, publicId, systemId, internalSubset, true);
    }

    protected OMElement createOMElement(OMContainer parent, String localName, String namespaceURI, String prefix, String[] namespaces, int namespaceCount) {
        OMElement element = this.factory.createOMElement(localName, parent, (OMXMLParserWrapper)this);
        int i = 0;
        while (i < namespaceCount) {
            ((OMElementEx)element).addNamespaceDeclaration(namespaces[2 * i + 1], namespaces[2 * i]);
            ++i;
        }
        BuilderUtil.setNamespace((OMElement)element, (String)namespaceURI, (String)prefix, (boolean)false);
        return element;
    }

    protected void completed(OMElement element) {
        ((OMElementEx)element).setComplete(true);
    }

    protected void createOMText(OMContainer parent, String text, int type) {
        this.factory.createOMText(parent, text, type, true);
    }

    protected void createOMProcessingInstruction(OMContainer parent, String piTarget, String piData) {
        this.factory.createOMProcessingInstruction(parent, piTarget, piData, true);
    }

    protected void createOMComment(OMContainer parent, String content) {
        this.factory.createOMComment(parent, content, true);
    }

    protected void createOMEntityReference(OMContainer parent, String name, String replacementText) {
        this.factory.createOMEntityReference(parent, name, replacementText, true);
    }

    public void detach() {
        this.getDocument();
    }
}

