/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.crmf;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class CertId
extends ASN1Encodable {
    private GeneralName issuer;
    private DERInteger serialNumber;

    private CertId(ASN1Sequence aSN1Sequence) {
        this.issuer = GeneralName.getInstance(aSN1Sequence.getObjectAt(0));
        this.serialNumber = DERInteger.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static CertId getInstance(Object object) {
        if (object instanceof CertId) {
            return (CertId)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertId((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public static CertId getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CertId.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public GeneralName getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.issuer);
        aSN1EncodableVector.add(this.serialNumber);
        return new DERSequence(aSN1EncodableVector);
    }
}

