/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.ssl.HostPort;
import org.apache.commons.ssl.Util;

public class SSLProxyServer {
    public static void main(String[] args) throws Exception {
        int port = 7444;
        if (args.length >= 1) {
            port = Integer.parseInt(args[0]);
        }
        ServerSocket ss = new ServerSocket(port);
        System.out.println("SSL Proxy server listening on port: " + port);
        while (true) {
            Socket s = ss.accept();
            s.setSoTimeout(10000);
            ProxyRunnable r = new ProxyRunnable(s);
            new Thread(r).start();
        }
    }

    public static class ProxyRunnable
    implements Runnable {
        private Socket s;

        public ProxyRunnable(Socket s) {
            this.s = s;
        }

        public void run() {
            InputStream in = null;
            OutputStream out = null;
            InputStream newIn = null;
            OutputStream newOut = null;
            Socket newSocket = new Socket();
            System.out.println("Socket accepted!");
            try {
                in = this.s.getInputStream();
                out = this.s.getOutputStream();
                String line = Util.readLine(in);
                line = line.trim();
                String connect = line.substring(0, "CONNECT".length());
                InetSocketAddress addr = null;
                if (!"CONNECT".equalsIgnoreCase(connect)) {
                    throw new IOException("not a proxy request: " + line);
                }
                line = line.substring("CONNECT".length()).trim();
                line = line.substring(0, line.length() - "HTTP/1.1".length()).trim();
                HostPort hostPort = Util.toAddress(line, 443);
                addr = new InetSocketAddress(hostPort.host, hostPort.port);
                System.out.println("Attempting to proxy to: " + line);
                int avail = in.available();
                in.skip(avail);
                Thread.yield();
                avail = in.available();
                while (avail != 0) {
                    in.skip(avail);
                    Thread.yield();
                    avail = in.available();
                }
                InetSocketAddress local = new InetSocketAddress(0);
                newSocket.setSoTimeout(10000);
                newSocket.bind(local);
                newSocket.connect(addr, 5000);
                newIn = newSocket.getInputStream();
                newOut = newSocket.getOutputStream();
                out.write("HTTP/1.1 200 OKAY\r\n\r\n".getBytes());
                out.flush();
                IOException[] e = new IOException[1];
                InputStream rIn = in;
                OutputStream rNewOut = newOut;
                Runnable r = new Runnable(this, rIn, rNewOut, e){
                    private final /* synthetic */ InputStream val$rIn;
                    private final /* synthetic */ OutputStream val$rNewOut;
                    private final /* synthetic */ IOException[] val$e;
                    private final /* synthetic */ ProxyRunnable this$0;
                    {
                        this.this$0 = this$0;
                        this.val$rIn = val$rIn;
                        this.val$rNewOut = val$rNewOut;
                        this.val$e = val$e;
                    }

                    public void run() {
                        try {
                            byte[] buf = new byte[4096];
                            int read = this.val$rIn.read(buf);
                            while (read >= 0) {
                                if (read > 0) {
                                    this.val$rNewOut.write(buf, 0, read);
                                    this.val$rNewOut.flush();
                                }
                                read = this.val$rIn.read(buf);
                            }
                        }
                        catch (IOException ioe) {
                            this.val$e[0] = ioe;
                        }
                    }
                };
                new Thread(r).start();
                byte[] buf = new byte[4096];
                int read = newIn.read(buf);
                while (read >= 0) {
                    if (read > 0) {
                        out.write(buf, 0, read);
                        out.flush();
                    }
                    if (e[0] != null) {
                        throw e[0];
                    }
                    read = newIn.read(buf);
                }
            }
            catch (IOException ioe) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    this.s.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (newOut != null) {
                        newOut.close();
                    }
                    if (newIn != null) {
                        newIn.close();
                    }
                    newSocket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ioe instanceof InterruptedIOException) {
                    System.out.println("Socket closed after 10 second timeout.");
                }
                ioe.printStackTrace();
            }
        }
    }
}

