/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Token;

public class IssuedToken
extends Token {
    private OMElement issuerEpr;
    private OMElement issuerMex;
    private OMElement rstTemplate;
    boolean requireExternalReference;
    boolean requireInternalReference;

    public IssuedToken(int version) {
        this.setVersion(version);
    }

    public OMElement getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(OMElement issuerEpr) {
        this.issuerEpr = issuerEpr;
    }

    public boolean isRequireExternalReference() {
        return this.requireExternalReference;
    }

    public void setRequireExternalReference(boolean requireExternalReference) {
        this.requireExternalReference = requireExternalReference;
    }

    public boolean isRequireInternalReference() {
        return this.requireInternalReference;
    }

    public void setRequireInternalReference(boolean requireInternalReference) {
        this.requireInternalReference = requireInternalReference;
    }

    public OMElement getRstTemplate() {
        return this.rstTemplate;
    }

    public void setRstTemplate(OMElement rstTemplate) {
        this.rstTemplate = rstTemplate;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.ISSUED_TOKEN;
        }
        return SP11Constants.ISSUED_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        IssuedToken.writeStartElement(writer, prefix, localname, namespaceURI);
        String inclusion = this.version == 2 ? SP12Constants.getAttributeValueFromInclusion(this.getInclusion()) : SP11Constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            IssuedToken.writeAttribute(writer, prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            IssuedToken.writeStartElement(writer, prefix, "Issuer", namespaceURI);
            this.issuerEpr.serialize(writer);
            writer.writeEndElement();
        }
        if (this.rstTemplate != null) {
            this.rstTemplate.serialize(writer);
        }
        if (this.isRequireExternalReference() || this.isRequireInternalReference() || this.isDerivedKeys()) {
            IssuedToken.writeStartElement(writer, SPConstants.POLICY);
            if (this.isRequireExternalReference()) {
                IssuedToken.writeEmptyElement(writer, prefix, "RequireExternalReference", namespaceURI);
            }
            if (this.isRequireInternalReference()) {
                IssuedToken.writeEmptyElement(writer, prefix, "RequireInternalReference", namespaceURI);
            }
            if (this.isDerivedKeys()) {
                IssuedToken.writeEmptyElement(writer, prefix, "RequireDerivedKeys", namespaceURI);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public OMElement getIssuerMex() {
        return this.issuerMex;
    }

    public void setIssuerMex(OMElement issuerMex) {
        this.issuerMex = issuerMex;
    }
}

