/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.TransportMBeanSupport;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.transport.nhttp.ListenerContext;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;
import org.apache.synapse.transport.utils.conn.logging.LoggingUtils;

public class HttpCoreNIOListener
implements TransportListener,
ManagementSupport {
    private static final Log log = LogFactory.getLog(HttpCoreNIOListener.class);
    private DefaultListeningIOReactor ioReactor = null;
    private String serviceEPRPrefix;
    private String customEPRPrefix;
    private Map<String, String> serviceNameToEPRMap = new HashMap<String, String>();
    private Map<String, String> eprToServiceNameMap = new HashMap<String, String>();
    private final AxisObserver axisObserver = new GenericAxisObserver();
    private SSLContext sslContext = null;
    private SSLSetupHandler sslSetupHandler = null;
    private TransportMBeanSupport mbeanSupport;
    private volatile int state = 0;
    private ServerHandler handler = null;
    private ListenerContext listenerContext;
    private NhttpMetricsCollector metrics = null;

    protected IOEventDispatch getEventDispatch(NHttpServerEventHandler handler, SSLContext sslContext, SSLSetupHandler setupHandler, ConnectionConfig config) {
        return LoggingUtils.getServerIODispatch(handler, config);
    }

    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        cfgCtx.setProperty("service.epr.map", this.eprToServiceNameMap);
        this.sslContext = this.getSSLContext(transportIn);
        this.sslSetupHandler = this.getSSLIOSessionHandler(transportIn);
        this.listenerContext = new ListenerContext(cfgCtx, transportIn, this.sslContext != null);
        this.listenerContext.build();
        this.metrics = this.listenerContext.getMetrics();
        Parameter param = transportIn.getParameter("WSDLEPRPrefix");
        if (param != null) {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(cfgCtx, (String)param.getValue());
            this.customEPRPrefix = (String)param.getValue();
        } else {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(cfgCtx, this.listenerContext.getHost(), this.listenerContext.getPort());
            this.customEPRPrefix = transportIn.getName() + "://" + this.listenerContext.getHost() + ":" + (this.listenerContext.getPort() == 80 ? "" : Integer.valueOf(this.listenerContext.getPort())) + "/";
        }
        cfgCtx.getAxisConfiguration().addObservers(this.axisObserver);
        this.mbeanSupport = new TransportMBeanSupport((TransportListener)this, "nio-" + transportIn.getName());
        this.mbeanSupport.register();
    }

    public int getActiveConnectionsSize() {
        return this.handler.getActiveConnectionsSize();
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return "http://" + host + (port == 80 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String wsdlEPRPrefix) {
        return wsdlEPRPrefix + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected SSLContext getSSLContext(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    protected SSLSetupHandler getSSLIOSessionHandler(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    public void start() throws AxisFault {
        ListenerEndpoint endpoint;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting Listener...");
        }
        try {
            String prefix = (this.sslContext == null ? "http" : "https") + "-Listener I/O dispatcher";
            this.ioReactor = new DefaultListeningIOReactor(this.listenerContext.getReactorConfig(), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " thread group"), prefix));
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOException e) {
            this.handleException("Error starting the IOReactor", e);
        }
        ConfigurationContext cfgCtx = this.listenerContext.getCfgCtx();
        for (Object obj : cfgCtx.getAxisConfiguration().getServices().values()) {
            this.addToServiceURIMap((AxisService)obj);
        }
        this.handler = new ServerHandler(this.listenerContext);
        final IOEventDispatch ioEventDispatch = this.getEventDispatch(this.handler, this.sslContext, this.sslSetupHandler, this.listenerContext.getConnectionConfig());
        this.state = 1;
        this.listenerContext.getHttpGetRequestProcessor().init(cfgCtx, this.handler);
        try {
            endpoint = this.listenerContext.getBindAddress() == null ? this.ioReactor.listen((SocketAddress)new InetSocketAddress(this.listenerContext.getPort())) : this.ioReactor.listen((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.listenerContext.getBindAddress()), this.listenerContext.getPort()));
        }
        catch (IOException e) {
            this.handleException("Encountered an I/O error: " + e.getMessage(), e);
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpCoreNIOListener.this.ioReactor.execute(ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    log.fatal((Object)"Reactor Interrupted", (Throwable)ex);
                }
                catch (IOException e) {
                    log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
                }
                catch (Exception e) {
                    log.fatal((Object)"Unexpected exception in I/O reactor", (Throwable)e);
                }
                log.info((Object)((HttpCoreNIOListener.this.sslContext == null ? "HTTP" : "HTTPS") + " Listener Shutdown"));
            }
        }, "HttpCoreNIOListener");
        t.start();
        try {
            endpoint.waitFor();
        }
        catch (InterruptedException e) {
            log.warn((Object)"HttpCoreNIOListener#start() was interrupted");
        }
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Listener started on" + (this.listenerContext.getBindAddress() != null ? " address : " + this.listenerContext.getBindAddress() : "") + " port : " + this.listenerContext.getPort()));
    }

    private void addToServiceURIMap(AxisService service) {
        Parameter param = service.getParameter("ServiceURI");
        if (param != null) {
            String uriLocation = param.getValue().toString();
            if (uriLocation.startsWith("/")) {
                uriLocation = uriLocation.substring(1);
            }
            this.serviceNameToEPRMap.put(service.getName(), uriLocation);
            this.eprToServiceNameMap.put(uriLocation, service.getName());
        }
    }

    private void removeServiceFromURIMap(AxisService service) {
        this.eprToServiceNameMap.remove(this.serviceNameToEPRMap.get(service.getName()));
        this.serviceNameToEPRMap.remove(service.getName());
    }

    public void stop() throws AxisFault {
        if (this.state == 0) {
            return;
        }
        try {
            this.ioReactor.shutdown();
            this.handler.stop();
            this.state = 0;
            for (Object obj : this.listenerContext.getCfgCtx().getAxisConfiguration().getServices().values()) {
                this.removeServiceFromURIMap((AxisService)obj);
            }
        }
        catch (IOException e) {
            this.handleException("Error shutting down IOReactor", e);
        }
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            this.ioReactor.pause();
            this.handler.markActiveConnectionsToBeClosed();
            this.state = 2;
            log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Listener Paused"));
        }
        catch (IOException e) {
            this.handleException("Error pausing IOReactor", e);
        }
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            this.ioReactor.resume();
            this.state = 1;
            log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + "Listener Resumed"));
        }
        catch (IOException e) {
            this.handleException("Error resuming IOReactor", e);
        }
    }

    public int getActiveThreadCount() {
        return this.handler.getActiveCount();
    }

    public int getQueueSize() {
        return this.handler.getQueueSize();
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.pause();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenance", e);
        }
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String trailer = "";
        if (serviceName.indexOf(47) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("/"));
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("."));
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        EndpointReference[] endpointReferences = new EndpointReference[1];
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            endpointReferences[0] = new EndpointReference(this.customEPRPrefix + this.serviceNameToEPRMap.get(serviceName) + trailer);
        } else {
            if (this.serviceEPRPrefix == null) {
                return null;
            }
            endpointReferences[0] = new EndpointReference(this.serviceEPRPrefix + serviceName + trailer);
        }
        return endpointReferences;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        this.ioReactor = null;
        this.listenerContext.getCfgCtx().getAxisConfiguration().getObserversList().remove(this.axisObserver);
        this.mbeanSupport.unregister();
        this.metrics.destroy();
    }

    private boolean ignoreService(AxisService service) {
        return service.getName().startsWith("__") || JavaUtils.isTrueExplicitly((Object)service.getParameter("hiddenService"));
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }

    class GenericAxisObserver
    implements AxisObserver {
        GenericAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (!HttpCoreNIOListener.this.ignoreService(service) && BaseUtils.isUsingTransport((AxisService)service, (String)HttpCoreNIOListener.this.listenerContext.getTransportIn().getName())) {
                switch (event.getEventType()) {
                    case 1: {
                        HttpCoreNIOListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 0: {
                        HttpCoreNIOListener.this.removeServiceFromURIMap(service);
                        break;
                    }
                    case 3: {
                        HttpCoreNIOListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 2: {
                        HttpCoreNIOListener.this.removeServiceFromURIMap(service);
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter param) throws AxisFault {
        }

        public void removeParameter(Parameter param) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList<Parameter> getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

