/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpCoreRequestResponseTransport
implements RequestResponseTransport {
    private static final Log log = LogFactory.getLog(HttpCoreRequestResponseTransport.class);
    private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
    private MessageContext msgContext = null;
    private boolean responseWritten = false;

    public HttpCoreRequestResponseTransport(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Acking one-way request");
        }
        if (AddressingHelper.isReplyRedirected((MessageContext)msgContext) && !msgContext.getReplyTo().hasNoneAddress() || "http://www.w3.org/ns/wsdl/in-only".equals(msgContext.getOperationContext().getAxisOperation().getMessageExchangePattern())) {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"false");
        }
    }

    public void awaitResponse() throws InterruptedException, AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returning thread but keeping socket open -- awaiting response");
        }
        this.status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        this.msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
    }

    public void signalResponseReady() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Signal response available");
        }
        this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
    }

    public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
        return this.status;
    }

    public void signalFaultReady(AxisFault fault) {
    }

    public boolean isResponseWritten() {
        return this.responseWritten;
    }

    public void setResponseWritten(boolean responseWritten) {
        this.responseWritten = responseWritten;
    }
}

