/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.synapse.transport.utils.config.HttpTransportConfiguration;

public final class NHttpConfiguration
extends HttpTransportConfiguration {
    private static final int WORKERS_CORE_THREADS = 20;
    private static final int WORKERS_MAX_THREADS = 100;
    private static final int WORKER_KEEP_ALIVE = 5;
    private static final int BLOCKING_QUEUE_LENGTH = -1;
    private static final int IO_WORKER_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int BUFFER_SIZE = 8192;
    private static final String S_T_CORE = "snd_t_core";
    private static final String S_T_MAX = "snd_t_max";
    private static final String S_T_ALIVE = "snd_alive_sec";
    private static final String S_T_QLEN = "snd_qlen";
    private static final String C_T_CORE = "lst_t_core";
    private static final String C_T_MAX = "lst_t_max";
    private static final String C_T_ALIVE = "lst_alive_sec";
    private static final String C_T_QLEN = "lst_qlen";
    private static final String IO_WORKERS = "io_threads_per_reactor";
    private static final String G_BUFFER_SIZE = "nhttp_buffer_size";
    private static final String G_DISABLED_HTTP_METHODS = "nhttp_disabled_methods";
    private static NHttpConfiguration _instance = new NHttpConfiguration();
    private List<String> methods;
    private List<String> preserveHeaders;
    public static final String BLOCK_SERVICE_LIST = "http.block_service_list";
    public static final String BLOCK_SERVICE_LIST_DEFAULT = "false";

    private NHttpConfiguration() {
        super("nhttp");
        this.populatePreserveHttpHeaders();
    }

    @Override
    protected int getThreadsPerReactor() {
        return this.getIntProperty(IO_WORKERS, IO_WORKER_COUNT);
    }

    public static NHttpConfiguration getInstance() {
        return _instance;
    }

    public int getServerCoreThreads() {
        return this.getIntProperty(S_T_CORE, 20);
    }

    public int getServerMaxThreads() {
        return this.getIntProperty(S_T_MAX, 100);
    }

    public int getServerKeepalive() {
        return this.getIntProperty(S_T_ALIVE, 5);
    }

    public int getServerQueueLen() {
        return this.getIntProperty(S_T_QLEN, -1);
    }

    public int getClientCoreThreads() {
        return this.getIntProperty(C_T_CORE, 20);
    }

    public int getClientMaxThreads() {
        return this.getIntProperty(C_T_MAX, 100);
    }

    public int getClientKeepalive() {
        return this.getIntProperty(C_T_ALIVE, 5);
    }

    public int getClientQueueLen() {
        return this.getIntProperty(C_T_QLEN, -1);
    }

    public int getBufferSize() {
        return this.getIntProperty(G_BUFFER_SIZE, 8192);
    }

    public boolean isKeepAliveDisabled() {
        return this.getIntProperty("http.connection.disable.keepalive", 0) == 1;
    }

    public boolean isCountConnections() {
        return this.getBooleanProperty("http.count.connections", false);
    }

    public String isServiceListBlocked() {
        return this.getStringProperty(BLOCK_SERVICE_LIST, BLOCK_SERVICE_LIST_DEFAULT);
    }

    public boolean isHttpMethodDisabled(String method) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
            String methodsString = this.getStringProperty(G_DISABLED_HTTP_METHODS, "");
            for (String methodStr : methodsString.split(",")) {
                this.methods.add(methodStr.trim().toUpperCase());
            }
        }
        return this.methods.contains(method);
    }

    public boolean isPreserveHttpHeader(String httpHeader) {
        if (this.preserveHeaders == null || this.preserveHeaders.isEmpty() || httpHeader == null) {
            return false;
        }
        return this.preserveHeaders.contains(httpHeader.toUpperCase());
    }

    private void populatePreserveHttpHeaders() {
        if (this.preserveHeaders == null) {
            String[] splitHeaders;
            this.preserveHeaders = new ArrayList<String>();
            String presHeaders = this.getStringProperty("http.headers.preserve", "");
            if (presHeaders != null && !presHeaders.isEmpty() && (splitHeaders = presHeaders.toUpperCase().trim().split(",")) != null && splitHeaders.length > 0) {
                this.preserveHeaders.addAll(Arrays.asList(splitHeaders));
            }
            if (this.getBooleanProperty("http.server.preserve", true).booleanValue() && !this.preserveHeaders.contains("Server".toUpperCase())) {
                this.preserveHeaders.add("Server".toUpperCase());
            }
            if (this.getBooleanProperty("http.user.agent.preserve", false).booleanValue() && !this.preserveHeaders.contains("User-Agent".toUpperCase())) {
                this.preserveHeaders.add("User-Agent".toUpperCase());
            }
        }
    }
}

