/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpProcessor;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.util.BufferFactory;

public abstract class BaseConfiguration {
    protected ParameterInclude parameters = null;
    private WorkerPool workerPool = null;
    private ConfigurationContext configurationContext = null;
    private BufferFactory bufferFactory = null;
    private PassThroughTransportMetricsCollector metrics = null;
    private HttpProcessor httpProcessor;
    protected PassThroughConfiguration conf = PassThroughConfiguration.getInstance();

    public BaseConfiguration(ConfigurationContext configurationContext, ParameterInclude parameters, WorkerPool workerPool) {
        this.parameters = parameters;
        this.configurationContext = configurationContext;
        this.workerPool = workerPool == null ? WorkerPoolFactory.getWorkerPool((int)this.conf.getWorkerPoolCoreSize(), (int)this.conf.getWorkerPoolMaxSize(), (int)this.conf.getWorkerThreadKeepaliveSec(), (int)this.conf.getWorkerPoolQueueLen(), (String)"Pass-through Message Processing Thread Group", (String)"PassThroughMessageProcessor") : workerPool;
        int bufferSize = this.conf.getIntProperty("io_buffer_size", 8192);
        this.bufferFactory = new BufferFactory(bufferSize, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, 512);
        this.httpProcessor = this.initHttpProcessor();
    }

    protected abstract HttpProcessor initHttpProcessor();

    public IOReactorConfig getReactorConfig(boolean listener) {
        if (listener) {
            return this.conf.getListeningReactorConfig();
        }
        return this.conf.getConnectingReactorConfig();
    }

    public ConnectionConfig getConnectionConfig() {
        return this.conf.getConnectionConfig();
    }

    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public BufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public PassThroughTransportMetricsCollector getMetrics() {
        return this.metrics;
    }

    public void setMetrics(PassThroughTransportMetricsCollector metrics) {
        this.metrics = metrics;
    }
}

