/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.connections.TargetConnections;

public class TargetConfiguration
extends BaseConfiguration {
    private int maxConnections = this.conf.getIntProperty("http.max.connection.per.target", Integer.MAX_VALUE);
    private boolean preserveUserAgentHeader = this.conf.getBooleanProperty("http.user.agent.preserve", false);
    private boolean preserveServerHeader = this.conf.getBooleanProperty("http.server.preserve", true);
    private List<String> preserveHttpHeaders;
    private TargetConnections connections = null;

    public TargetConfiguration(ConfigurationContext configurationContext, ParameterInclude parameters, WorkerPool pool) {
        super(configurationContext, parameters, pool);
        this.populatePreserveHttpHeaders(this.conf.getPreserveHttpHeaders());
    }

    @Override
    protected HttpProcessor initHttpProcessor() {
        String userAgent = this.conf.getStringProperty("http.user.agent.value", "Synapse-PT-HttpComponents-NIO");
        return new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(userAgent), new RequestExpectContinue(false)});
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isPreserveHttpHeader(String headerName) {
        if (this.preserveHttpHeaders == null || this.preserveHttpHeaders.isEmpty() || headerName == null) {
            return false;
        }
        return this.preserveHttpHeaders.contains(headerName.toUpperCase());
    }

    public TargetConnections getConnections() {
        return this.connections;
    }

    public void setConnections(TargetConnections connections) {
        this.connections = connections;
    }

    private void populatePreserveHttpHeaders(String preserveHeaders) {
        String[] presHeaders;
        this.preserveHttpHeaders = new ArrayList<String>();
        if (preserveHeaders != null && !preserveHeaders.isEmpty() && (presHeaders = preserveHeaders.trim().toUpperCase().split(",")) != null && presHeaders.length > 0) {
            this.preserveHttpHeaders.addAll(Arrays.asList(presHeaders));
        }
        if (this.preserveServerHeader && !this.preserveHttpHeaders.contains("Server".toUpperCase())) {
            this.preserveHttpHeaders.add("Server".toUpperCase());
        }
        if (this.preserveUserAgentHeader && !this.preserveHttpHeaders.contains("User-Agent".toUpperCase())) {
            this.preserveHttpHeaders.add("User-Agent".toUpperCase());
        }
    }
}

