/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.cert.CertificateEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationException;
import org.apache.synapse.transport.utils.sslcert.RevocationVerifier;
import org.apache.synapse.transport.utils.sslcert.crl.CRLCache;
import org.apache.synapse.transport.utils.sslcert.crl.CRLVerifier;
import org.apache.synapse.transport.utils.sslcert.ocsp.OCSPCache;
import org.apache.synapse.transport.utils.sslcert.ocsp.OCSPVerifier;
import org.apache.synapse.transport.utils.sslcert.pathvalidation.CertificatePathValidator;

public class RevocationVerificationManager {
    private int cacheSize = 50;
    private int cacheDurationMins = 15;
    private static final Log log = LogFactory.getLog(RevocationVerificationManager.class);

    public RevocationVerificationManager(Integer cacheAllocatedSize, Integer cacheDurationMins) {
        if (cacheAllocatedSize != null && cacheAllocatedSize > 50 && cacheAllocatedSize < 10000) {
            this.cacheSize = cacheAllocatedSize;
        }
        if (cacheDurationMins != null && cacheDurationMins > 1 && cacheDurationMins < 1440) {
            this.cacheDurationMins = cacheDurationMins;
        }
    }

    public void verifyRevocationStatus(javax.security.cert.X509Certificate[] peerCertificates) throws CertificateVerificationException {
        RevocationVerifier[] verifiers;
        X509Certificate[] convertedCertificates = this.convert(peerCertificates);
        long start = System.currentTimeMillis();
        OCSPCache ocspCache = OCSPCache.getCache();
        ocspCache.init(this.cacheSize, this.cacheDurationMins);
        CRLCache crlCache = CRLCache.getCache();
        crlCache.init(this.cacheSize, this.cacheDurationMins);
        for (RevocationVerifier verifier : verifiers = new RevocationVerifier[]{new OCSPVerifier(ocspCache), new CRLVerifier(crlCache)}) {
            try {
                CertificatePathValidator pathValidator = new CertificatePathValidator(convertedCertificates, verifier);
                pathValidator.validatePath();
                log.info((Object)("Path verification Successful with " + verifier.getClass().getSimpleName() + ". Took " + (System.currentTimeMillis() - start) + " ms."));
                return;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Certificate verification with " + verifier.getClass().getSimpleName() + " failed. "), (Throwable)e);
            }
        }
        throw new CertificateVerificationException("Path Verification Failed for both OCSP and CRL");
    }

    private X509Certificate[] convert(javax.security.cert.X509Certificate[] certs) throws CertificateVerificationException {
        X509Certificate[] certChain = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            Exception exceptionThrown;
            try {
                byte[] encoded = certs[i].getEncoded();
                ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certChain[i] = (X509Certificate)cf.generateCertificate(bis);
                continue;
            }
            catch (java.security.cert.CertificateEncodingException e) {
                exceptionThrown = e;
            }
            catch (CertificateEncodingException e) {
                exceptionThrown = e;
            }
            catch (CertificateException e) {
                exceptionThrown = e;
            }
            throw new CertificateVerificationException("Cant Convert certificates from javax to java", exceptionThrown);
        }
        return certChain;
    }
}

