/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.NameIDMappingRequest;
import org.opensaml.saml2.core.validator.RequestAbstractTypeSchemaValidator;
import org.opensaml.xml.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameIDMappingRequestSchemaValidator
extends RequestAbstractTypeSchemaValidator<NameIDMappingRequest> {
    @Override
    public void validate(NameIDMappingRequest request) throws ValidationException {
        super.validate(request);
        this.validateIdentifiers(request);
        this.validateNameIDPolicy(request);
    }

    protected void validateIdentifiers(NameIDMappingRequest request) throws ValidationException {
        int idCount = 0;
        if (request.getBaseID() != null) {
            ++idCount;
        }
        if (request.getNameID() != null) {
            ++idCount;
        }
        if (request.getEncryptedID() != null) {
            ++idCount;
        }
        if (idCount != 1) {
            throw new ValidationException("NameIDMappingRequest must contain exactly one of: BaseID, NameID, EncryptedID");
        }
    }

    private void validateNameIDPolicy(NameIDMappingRequest request) throws ValidationException {
        if (request.getNameIDPolicy() == null) {
            throw new ValidationException("NameIDPolicy is required");
        }
    }
}

