/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.intf;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11Body;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11Envelope;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11Fault;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11FaultCode;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11FaultDetail;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11FaultReason;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11FaultRole;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11Header;
import org.apache.axiom.soap.impl.intf.AxiomSOAP11HeaderBlock;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12Body;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12Envelope;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12Fault;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12FaultCode;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12FaultDetail;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12FaultReason;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12FaultRole;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12Header;
import org.apache.axiom.soap.impl.intf.AxiomSOAP12HeaderBlock;
import org.apache.axiom.soap.impl.intf.AxiomSOAPBody;
import org.apache.axiom.soap.impl.intf.AxiomSOAPEnvelope;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFault;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultCode;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultDetail;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultReason;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultRole;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeader;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SOAPHelper {
    public static final SOAPHelper SOAP11 = new SOAPHelper((SOAPVersion)SOAP11Version.getSingleton(), "SOAP 1.1", AxiomSOAP11Envelope.class, AxiomSOAP11Header.class, AxiomSOAP11HeaderBlock.class, AxiomSOAP11Body.class, AxiomSOAP11Fault.class, AxiomSOAP11FaultCode.class, AxiomSOAP11FaultReason.class, AxiomSOAP11FaultRole.class, AxiomSOAP11FaultDetail.class, "actor", null){

        public SOAPFactory getSOAPFactory(OMMetaFactory metaFactory) {
            return metaFactory.getSOAP11Factory();
        }

        public Boolean parseBoolean(String literal) {
            if (literal.equals("1")) {
                return Boolean.TRUE;
            }
            if (literal.equals("0")) {
                return Boolean.FALSE;
            }
            return null;
        }

        public String formatBoolean(boolean value) {
            return value ? "1" : "0";
        }
    };
    public static final SOAPHelper SOAP12 = new SOAPHelper((SOAPVersion)SOAP12Version.getSingleton(), "SOAP 1.2", AxiomSOAP12Envelope.class, AxiomSOAP12Header.class, AxiomSOAP12HeaderBlock.class, AxiomSOAP12Body.class, AxiomSOAP12Fault.class, AxiomSOAP12FaultCode.class, AxiomSOAP12FaultReason.class, AxiomSOAP12FaultRole.class, AxiomSOAP12FaultDetail.class, "role", "relay"){

        public SOAPFactory getSOAPFactory(OMMetaFactory metaFactory) {
            return metaFactory.getSOAP12Factory();
        }

        public Boolean parseBoolean(String literal) {
            if (literal.equals("true") || literal.equals("1")) {
                return Boolean.TRUE;
            }
            if (literal.equals("false") || literal.equals("0")) {
                return Boolean.FALSE;
            }
            return null;
        }

        public String formatBoolean(boolean value) {
            return String.valueOf(value);
        }
    };
    private final SOAPVersion version;
    private final OMNamespace namespace;
    private final String specName;
    private final Class<? extends AxiomSOAPEnvelope> envelopeClass;
    private final Class<? extends AxiomSOAPHeader> headerClass;
    private final QName headerQName;
    private final Class<? extends AxiomSOAPHeaderBlock> headerBlockClass;
    private final Class<? extends AxiomSOAPBody> bodyClass;
    private final QName bodyQName;
    private final Class<? extends AxiomSOAPFault> faultClass;
    private final QName faultQName;
    private final Class<? extends AxiomSOAPFaultCode> faultCodeClass;
    private final Class<? extends AxiomSOAPFaultReason> faultReasonClass;
    private final Class<? extends AxiomSOAPFaultRole> faultRoleClass;
    private final Class<? extends AxiomSOAPFaultDetail> faultDetailClass;
    private final QName mustUnderstandAttributeQName;
    private final QName roleAttributeQName;
    private final QName relayAttributeQName;

    private SOAPHelper(SOAPVersion version, String specName, Class<? extends AxiomSOAPEnvelope> envelopeClass, Class<? extends AxiomSOAPHeader> headerClass, Class<? extends AxiomSOAPHeaderBlock> headerBlockClass, Class<? extends AxiomSOAPBody> bodyClass, Class<? extends AxiomSOAPFault> faultClass, Class<? extends AxiomSOAPFaultCode> faultCodeClass, Class<? extends AxiomSOAPFaultReason> faultReasonClass, Class<? extends AxiomSOAPFaultRole> faultRoleClass, Class<? extends AxiomSOAPFaultDetail> faultDetailClass, String roleAttributeLocalName, String relayAttributeLocalName) {
        this.version = version;
        this.namespace = new OMNamespaceImpl(version.getEnvelopeURI(), "soapenv");
        this.specName = specName;
        this.envelopeClass = envelopeClass;
        this.headerClass = headerClass;
        this.headerQName = new QName(version.getEnvelopeURI(), "Header", "soapenv");
        this.headerBlockClass = headerBlockClass;
        this.bodyClass = bodyClass;
        this.bodyQName = new QName(version.getEnvelopeURI(), "Body", "soapenv");
        this.faultClass = faultClass;
        this.faultQName = new QName(version.getEnvelopeURI(), "Fault", "soapenv");
        this.faultCodeClass = faultCodeClass;
        this.faultReasonClass = faultReasonClass;
        this.faultRoleClass = faultRoleClass;
        this.faultDetailClass = faultDetailClass;
        this.mustUnderstandAttributeQName = new QName(version.getEnvelopeURI(), "mustUnderstand", "soapenv");
        this.roleAttributeQName = new QName(version.getEnvelopeURI(), roleAttributeLocalName, "soapenv");
        this.relayAttributeQName = relayAttributeLocalName == null ? null : new QName(version.getEnvelopeURI(), relayAttributeLocalName, "soapenv");
    }

    public final SOAPVersion getVersion() {
        return this.version;
    }

    public abstract SOAPFactory getSOAPFactory(OMMetaFactory var1);

    public final String getEnvelopeURI() {
        return this.version.getEnvelopeURI();
    }

    public final OMNamespace getNamespace() {
        return this.namespace;
    }

    public final String getSpecName() {
        return this.specName;
    }

    public final Class<? extends AxiomSOAPEnvelope> getEnvelopeClass() {
        return this.envelopeClass;
    }

    public final Class<? extends AxiomSOAPHeader> getHeaderClass() {
        return this.headerClass;
    }

    public final QName getHeaderQName() {
        return this.headerQName;
    }

    public final Class<? extends AxiomSOAPHeaderBlock> getHeaderBlockClass() {
        return this.headerBlockClass;
    }

    public final Class<? extends AxiomSOAPBody> getBodyClass() {
        return this.bodyClass;
    }

    public final QName getBodyQName() {
        return this.bodyQName;
    }

    public final Class<? extends AxiomSOAPFault> getFaultClass() {
        return this.faultClass;
    }

    public final QName getFaultQName() {
        return this.faultQName;
    }

    public final Class<? extends AxiomSOAPFaultCode> getFaultCodeClass() {
        return this.faultCodeClass;
    }

    public final QName getFaultCodeQName() {
        return this.version.getFaultCodeQName();
    }

    public final Class<? extends AxiomSOAPFaultReason> getFaultReasonClass() {
        return this.faultReasonClass;
    }

    public final QName getFaultReasonQName() {
        return this.version.getFaultReasonQName();
    }

    public final Class<? extends AxiomSOAPFaultRole> getFaultRoleClass() {
        return this.faultRoleClass;
    }

    public final QName getFaultRoleQName() {
        return this.version.getFaultRoleQName();
    }

    public final Class<? extends AxiomSOAPFaultDetail> getFaultDetailClass() {
        return this.faultDetailClass;
    }

    public final QName getFaultDetailQName() {
        return this.version.getFaultDetailQName();
    }

    public final QName getMustUnderstandAttributeQName() {
        return this.mustUnderstandAttributeQName;
    }

    public final QName getRoleAttributeQName() {
        return this.roleAttributeQName;
    }

    public final QName getRelayAttributeQName() {
        return this.relayAttributeQName;
    }

    public abstract Boolean parseBoolean(String var1);

    public abstract String formatBoolean(boolean var1);

    /* synthetic */ SOAPHelper(SOAPVersion sOAPVersion, String string, Class clazz, Class clazz2, Class clazz3, Class clazz4, Class clazz5, Class clazz6, Class clazz7, Class clazz8, Class clazz9, String string2, String string3, SOAPHelper sOAPHelper) {
        this(sOAPVersion, string, clazz, clazz2, clazz3, clazz4, clazz5, clazz6, clazz7, clazz8, clazz9, string2, string3);
    }
}

