/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceInformationRepository;
import org.apache.synapse.commons.datasource.DataSourceInformationRepositoryListener;
import org.apache.synapse.commons.datasource.DataSourceRepositoryManager;
import org.apache.synapse.commons.datasource.InMemoryDataSourceRepository;
import org.apache.synapse.commons.datasource.JNDIBasedDataSourceRepository;
import org.apache.synapse.commons.datasource.RepositoryBasedDataSourceFinder;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationRepositoryFactory;

public class DataSourceRepositoryHolder {
    private static final Log log = LogFactory.getLog(DataSourceRepositoryHolder.class);
    private static final DataSourceRepositoryHolder DATA_SOURCE_REPOSITORY_HOLDER = new DataSourceRepositoryHolder();
    private DataSourceInformationRepository dataSourceInformationRepository;
    private DataSourceRepositoryManager dataSourceRepositoryManager;
    private RepositoryBasedDataSourceFinder repositoryBasedDataSourceFinder;
    private boolean initialized = false;

    private DataSourceRepositoryHolder() {
    }

    public static DataSourceRepositoryHolder getInstance() {
        return DATA_SOURCE_REPOSITORY_HOLDER;
    }

    public void init(DataSourceInformationRepository repository, Properties properties) {
        if (this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Data source repository holder has already been initialized.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the data source repository holder");
        }
        DataSourceInformationRepositoryListener repositoryListener = null;
        if (repository != null) {
            repositoryListener = repository.getRepositoryListener();
        }
        if (repositoryListener == null) {
            repositoryListener = new DataSourceRepositoryManager(new InMemoryDataSourceRepository(), new JNDIBasedDataSourceRepository());
            if (repository != null) {
                repository.setRepositoryListener(repositoryListener);
            }
        }
        if (repositoryListener instanceof DataSourceRepositoryManager) {
            this.dataSourceRepositoryManager = (DataSourceRepositoryManager)repositoryListener;
            this.repositoryBasedDataSourceFinder = new RepositoryBasedDataSourceFinder();
            this.repositoryBasedDataSourceFinder.init(this.dataSourceRepositoryManager);
        }
        if (repository == null) {
            repository = DataSourceInformationRepositoryFactory.createDataSourceInformationRepository(repositoryListener, properties);
        } else {
            DataSourceInformationRepositoryFactory.setupDataSourceInformationRepository(repository, properties);
        }
        this.dataSourceInformationRepository = repository;
        this.initialized = true;
    }

    public DataSourceInformationRepository getDataSourceInformationRepository() {
        this.assertInitialized();
        return this.dataSourceInformationRepository;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            String msg = "Data source repository holder has not been initialized";
            log.error((Object)msg);
            throw new SynapseCommonsException(msg);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public DataSourceRepositoryManager getDataSourceRepositoryManager() {
        this.assertInitialized();
        return this.dataSourceRepositoryManager;
    }

    public RepositoryBasedDataSourceFinder getRepositoryBasedDataSourceFinder() {
        this.assertInitialized();
        return this.repositoryBasedDataSourceFinder;
    }
}

