/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;

public class ServerConfigurationInformation {
    private static final Log log = LogFactory.getLog(ServerConfigurationInformation.class);
    private final Map<String, String> properties = new HashMap<String, String>();
    private String axis2RepoLocation;
    private String axis2Xml;
    private String synapseHome;
    private String synapseXMLLocation;
    private String resolveRoot;
    private String serverName = "localhost";
    private String serverControllerProvider = "org.apache.synapse.Axis2SynapseController";
    private static final String DEFAULT_SERVER_CONTROLLER_PROVIDER = "org.apache.synapse.Axis2SynapseController";
    private boolean createNewInstance = true;
    private String hostName;
    private String ipAddress;
    private String deploymentMode;

    public ServerConfigurationInformation() {
        this.initServerHostAndIP();
    }

    public void setAxis2RepoLocation(String axis2RepoLocation) {
        this.assertNullOrEmpty(axis2RepoLocation, "axis2.repo");
        this.axis2RepoLocation = !new File(axis2RepoLocation).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + axis2RepoLocation : axis2RepoLocation;
    }

    public void setAxis2Xml(String axis2Xml) {
        this.assertNullOrEmpty(axis2Xml, "axis2.xml");
        this.axis2Xml = !new File(axis2Xml).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + axis2Xml : axis2Xml;
    }

    public void setSynapseHome(String synapseHome) {
        this.assertNullOrEmpty(synapseHome, "synapse.home");
        this.synapseHome = synapseHome;
    }

    public void setResolveRoot(String resolveRoot) {
        if (resolveRoot == null || "".equals(resolveRoot)) {
            return;
        }
        this.resolveRoot = !new File(resolveRoot).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + resolveRoot : resolveRoot;
    }

    public void setSynapseXMLLocation(String synapseXMLLocation) {
        this.assertNullOrEmpty(synapseXMLLocation, "synapse.xml");
        this.synapseXMLLocation = !new File(synapseXMLLocation).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + synapseXMLLocation : synapseXMLLocation;
    }

    public String getAxis2RepoLocation() {
        return this.axis2RepoLocation;
    }

    public String getAxis2Xml() {
        return this.axis2Xml;
    }

    public String getSynapseHome() {
        return this.synapseHome;
    }

    public String getSynapseXMLLocation() {
        return this.synapseXMLLocation;
    }

    public String getResolveRoot() {
        return this.resolveRoot;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerControllerProvider() {
        return this.serverControllerProvider;
    }

    public void setServerControllerProvider(String serverControllerProvider) {
        this.serverControllerProvider = serverControllerProvider;
    }

    public boolean isCreateNewInstance() {
        return this.createNewInstance;
    }

    public void setCreateNewInstance(boolean createNewInstance) {
        this.createNewInstance = createNewInstance;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public void addConfigurationProperty(String key, String value) {
        this.assertNullOrEmpty(key);
        this.assertNullOrEmpty(value, key);
        this.properties.put(key.trim(), value.trim());
    }

    public String getConfigurationProperty(String key) {
        this.assertNullOrEmpty(key);
        return this.properties.get(key.trim());
    }

    private void assertNullOrEmpty(String value, String paramter) {
        if (value == null || "".equals(value)) {
            this.handleFatal("The parameter - " + paramter + "  must be provided.");
        }
    }

    private void assertNullOrEmpty(String key) {
        if (key == null || "".equals(key)) {
            this.handleFatal("A configuration parameter is null or empty.");
        }
    }

    private void handleFatal(String msg) {
        log.fatal((Object)msg);
        throw new SynapseException(msg);
    }

    private void initServerHostAndIP() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr != null) {
                this.ipAddress = addr.getHostAddress();
                if (this.ipAddress != null) {
                    // empty if block
                }
                this.hostName = addr.getHostName();
                if (this.hostName == null) {
                    this.hostName = this.ipAddress;
                }
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Unable to get the hostName or IP address of the server", (Throwable)e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ Server Name : ").append(this.serverName).append(" ]");
        sb.append("[ Synapse Home : ").append(this.synapseHome).append(" ]");
        sb.append("[ Synapse XML : ").append(this.synapseXMLLocation).append(" ]");
        sb.append("[ Server Host : ").append(this.hostName).append(" ]");
        sb.append("[ Server IP : ").append(this.ipAddress).append(" ]");
        sb.append("[ Axis2 Repository : ").append(this.axis2RepoLocation).append(" ]");
        sb.append("[ Axis2 XML : ").append(this.axis2Xml).append(" ]");
        return sb.toString();
    }
}

