/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.MediatorFactory;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.StartupFactory;
import org.apache.synapse.config.xml.StartupFinder;

public class ExtensionDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(ExtensionDeployer.class);
    private ConfigurationContext cfgCtx = null;

    public void init(ConfigurationContext configurationContext) {
        this.cfgCtx = configurationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        log.info((Object)("Loading extensions from: " + deploymentFileData.getAbsolutePath()));
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz;
            QName tagQName;
            boolean isDirectory = deploymentFileData.getFile().isDirectory();
            deploymentFileData.setClassLoader(isDirectory, ((Object)((Object)this)).getClass().getClassLoader(), (File)this.cfgCtx.getAxisConfiguration().getParameterValue("artifactsDIR"), this.cfgCtx.getAxisConfiguration().isChildFirstClassLoading());
            DeploymentClassLoader urlCl = (DeploymentClassLoader)deploymentFileData.getClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)urlCl);
            for (StartupFactory startupFactory : this.getProviders(StartupFactory.class, (URLClassLoader)urlCl)) {
                tagQName = startupFactory.getTagQName();
                clazz = startupFactory.getClass();
                StartupFinder finder = StartupFinder.getInstance();
                finder.getFactoryMap().put(tagQName, clazz);
                finder.getSerializerMap().put(tagQName, startupFactory.getSerializerClass());
                log.info((Object)("Registered startup factory and serializer for " + tagQName));
            }
            for (MediatorFactory mediatorFactory : this.getProviders(MediatorFactory.class, (URLClassLoader)urlCl)) {
                tagQName = mediatorFactory.getTagQName();
                clazz = mediatorFactory.getClass();
                MediatorFactoryFinder.getInstance().getFactoryMap().put(tagQName, clazz);
                log.info((Object)("Registered mediator factory " + clazz.getName() + " for " + tagQName));
            }
            for (MediatorSerializer mediatorSerializer : this.getProviders(MediatorSerializer.class, (URLClassLoader)urlCl)) {
                String mediatorClassName = mediatorSerializer.getMediatorClassName();
                MediatorSerializerFinder.getInstance().getSerializerMap().put(mediatorClassName, mediatorSerializer);
                log.info((Object)("Registered mediator serializer " + mediatorSerializer.getClass().getName() + " for " + mediatorClassName));
            }
        }
        catch (IOException e) {
            this.handleException("I/O error in reading the mediator jar file", e);
        }
        catch (Exception e) {
            this.handleException("Error occurred while trying to deploy mediator jar file", e);
        }
        catch (Throwable t) {
            this.handleException("Error occurred while trying to deploy the mediator jar file", t);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Restoring the context class loader to the original");
            }
            Thread.currentThread().setContextClassLoader(prevCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> getProviders(Class<T> providerClass, URLClassLoader loader) throws IOException {
        LinkedList<T> providers = new LinkedList<T>();
        String providerClassName = providerClass.getName();
        providerClassName = providerClassName.substring(providerClassName.indexOf(46) + 1);
        URL servicesURL = loader.findResource("META-INF/services/" + providerClass.getName());
        if (servicesURL != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(servicesURL.openStream()));
            try {
                String className;
                while ((className = in.readLine()) != null && !className.trim().equals("")) {
                    log.info((Object)("Loading the " + providerClassName + " implementation: " + className));
                    try {
                        Class<T> clazz = loader.loadClass(className).asSubclass(providerClass);
                        providers.add(clazz.newInstance());
                    }
                    catch (ClassNotFoundException e) {
                        this.handleException("Unable to find the specified class on the path or in the jar file", e);
                    }
                    catch (IllegalAccessException e) {
                        this.handleException("Unable to load the class from the jar", e);
                    }
                    catch (InstantiationException e) {
                        this.handleException("Unable to instantiate the class specified", e);
                    }
                }
            }
            finally {
                in.close();
            }
        }
        return providers;
    }

    public void setDirectory(String string) {
    }

    public void setExtension(String string) {
    }

    public void undeploy(String string) throws DeploymentException {
    }

    private void handleException(String message, Exception e) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)message, (Throwable)e);
        }
        throw new DeploymentException(message, (Throwable)e);
    }

    private void handleException(String message, Throwable t) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)message, t);
        }
        throw new DeploymentException(message, t);
    }
}

