/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.eip;

import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.libraries.eip.EIPUtils;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class CalloutBlockMediator
extends AbstractMediator
implements ManagedLifecycle {
    private ThreadLocal<String> serviceURL = new ThreadLocal();
    private ThreadLocal<String> action = new ThreadLocal();
    private ThreadLocal<String> requestKey = new ThreadLocal();
    private ThreadLocal<SynapseXPath> requestXPath = new ThreadLocal();
    private ThreadLocal<SynapseXPath> targetXPath = new ThreadLocal();
    private ThreadLocal<String> targetKey = new ThreadLocal();
    private ConfigurationContext configCtx = null;
    private String clientRepository = null;
    private String axis2xml = null;
    private boolean passHeaders = false;
    public static final String DEFAULT_CLIENT_REPO = "./samples/axis2Client/client_repo";
    public static final String DEFAULT_AXIS2_XML = "./samples/axis2Client/client_repo/conf/axis2.xml";

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Callout mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        this.initParams(synCtx);
        try {
            SOAPHeader header;
            ServiceClient sc = new ServiceClient(this.configCtx, null);
            Options options = new Options();
            options.setTo(new EndpointReference(this.getServiceURL()));
            if (this.getAction() != null) {
                options.setAction(this.getAction());
            } else if (synCtx.isSOAP11()) {
                options.setProperty("disableSoapAction", (Object)true);
            } else {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getTransportOut().addParameter(new Parameter("OmitSOAP12Action", (Object)true));
            }
            if (this.passHeaders && (header = synCtx.getEnvelope().getHeader()) != null) {
                Iterator headerElements = header.cloneOMElement().getChildElements();
                while (headerElements.hasNext()) {
                    sc.addHeader((OMElement)headerElements.next());
                }
            }
            options.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
            sc.setOptions(options);
            OMElement request = this.getRequestPayload(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("About to invoke service : " + this.getServiceURL() + (this.getAction() != null ? " with action : " + this.getAction() : ""));
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Request message payload : " + request);
                }
            }
            OMElement result = null;
            try {
                options.setCallTransportCleanup(true);
                result = sc.sendReceive(request);
            }
            catch (AxisFault axisFault) {
                this.handleFault(synCtx, axisFault);
            }
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Response payload received : " + result);
            }
            if (result != null) {
                if (this.getTargetXPath() != null) {
                    Object o = this.getTargetXPath().evaluate(synCtx);
                    if (o != null && o instanceof OMElement) {
                        OMElement tgtNode = (OMElement)o;
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else if (o != null && o instanceof List && !((List)o).isEmpty()) {
                        OMElement tgtNode = (OMElement)((List)o).get(0);
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else {
                        this.handleException("Evaluation of target XPath expression : " + this.getTargetXPath().toString() + " did not yeild an OMNode", synCtx);
                    }
                }
                if (this.getTargetKey() != null) {
                    synCtx.setProperty(this.getTargetKey(), result);
                }
            } else {
                synLog.traceOrDebug("Service returned a null response");
            }
        }
        catch (AxisFault e) {
            this.handleException("Error invoking service : " + this.getServiceURL() + (this.getAction() != null ? " with action : " + this.getAction() : ""), (Exception)((Object)e), synCtx);
        }
        catch (JaxenException e) {
            this.handleException("Error while evaluating the XPath expression: " + (Object)((Object)this.getTargetXPath()), (Exception)((Object)e), synCtx);
        }
        synLog.traceOrDebug("End : Callout mediator");
        return true;
    }

    private void initParams(MessageContext synCtx) {
        String serURL = (String)EIPUtils.lookupFunctionParam(synCtx, "service_URL");
        if (serURL != null && !serURL.trim().equals("")) {
            this.setServiceURL(serURL);
        } else {
            this.handleException("The 'serviceURL' attribute is required for the Callout mediator", synCtx);
        }
        String soapAction = (String)EIPUtils.lookupFunctionParam(synCtx, "action");
        if (soapAction != null && !soapAction.trim().equals("")) {
            this.setAction(soapAction);
        }
        Object sXpath = EIPUtils.lookupFunctionParam(synCtx, "source_xpath");
        Object sKey = EIPUtils.lookupFunctionParam(synCtx, "source_key");
        if (sXpath != null && sXpath instanceof SynapseXPath) {
            try {
                this.setRequestXPath((SynapseXPath)((Object)sXpath));
            }
            catch (JaxenException e) {
                this.handleException("Invalid source XPath  ", synCtx);
            }
        } else if (sKey != null) {
            this.setRequestKey((String)sKey);
        } else {
            this.handleException("The message 'source' must be specified for a Callout mediator", synCtx);
        }
        Object tXpath = EIPUtils.lookupFunctionParam(synCtx, "target_xpath");
        Object tKey = EIPUtils.lookupFunctionParam(synCtx, "target_key");
        if (tXpath != null && tXpath instanceof SynapseXPath) {
            try {
                this.setTargetXPath((SynapseXPath)((Object)tXpath));
            }
            catch (JaxenException e) {
                this.handleException("Invalid target XPath  ", synCtx);
            }
        } else if (tKey != null) {
            this.setTargetKey((String)tKey);
        } else {
            this.handleException("The message 'target' must be specified for a Callout mediator", synCtx);
        }
    }

    private void handleFault(MessageContext synCtx, AxisFault axisFault) {
        synCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
        if (axisFault.getFaultCodeElement() != null) {
            synCtx.setProperty("ERROR_CODE", axisFault.getFaultCodeElement().getText());
        } else {
            synCtx.setProperty("ERROR_CODE", 401000);
        }
        if (axisFault.getFaultReasonElement() != null) {
            synCtx.setProperty("ERROR_MESSAGE", axisFault.getFaultReasonElement().getText());
        } else {
            synCtx.setProperty("ERROR_MESSAGE", "Error while performing the callout operation");
        }
        if (axisFault.getFaultDetailElement() != null) {
            if (axisFault.getFaultDetailElement().getFirstElement() != null) {
                synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getFirstElement());
            } else {
                synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getText());
            }
        }
        synCtx.setProperty("ERROR_EXCEPTION", (Object)axisFault);
        throw new SynapseException("Error while performing the callout operation", axisFault);
    }

    private OMElement getRequestPayload(MessageContext synCtx) throws AxisFault {
        if (this.getRequestKey() != null) {
            Object request = synCtx.getProperty(this.getRequestKey());
            if (request == null) {
                request = synCtx.getEntry(this.getRequestKey());
            }
            if (request != null && request instanceof OMElement) {
                return (OMElement)request;
            }
            this.handleException("The property : " + this.getRequestKey() + " is not an OMElement", synCtx);
        } else if (this.getRequestXPath() != null) {
            try {
                Object o = this.getRequestXPath().evaluate(MessageHelper.cloneMessageContext(synCtx));
                if (o instanceof OMElement) {
                    return (OMElement)o;
                }
                if (o instanceof List && !((List)o).isEmpty()) {
                    return (OMElement)((List)o).get(0);
                }
                this.handleException("The evaluation of the XPath expression : " + this.getRequestXPath().toString() + " did not result in an OMElement", synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.getRequestXPath().toString(), (Exception)((Object)e), synCtx);
            }
        }
        return null;
    }

    @Override
    public void init(SynapseEnvironment synEnv) {
        try {
            this.configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
        }
        catch (AxisFault e) {
            String msg = "Error initializing callout mediator : " + e.getMessage();
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.configCtx.terminate();
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL.set(serviceURL);
    }

    public void setAction(String action) {
        this.action.set(action);
    }

    public void setRequestKey(String requestKey) {
        this.requestKey.set(requestKey);
    }

    public void setRequestXPath(SynapseXPath requestXPath) throws JaxenException {
        this.requestXPath.set(requestXPath);
    }

    public void setTargetXPath(SynapseXPath targetXPath) throws JaxenException {
        this.targetXPath.set(targetXPath);
    }

    public void setTargetKey(String targetKey) {
        this.targetKey.set(targetKey);
    }

    public String getServiceURL() {
        return this.serviceURL.get();
    }

    public String getAction() {
        return this.action.get();
    }

    public String getRequestKey() {
        return this.requestKey.get();
    }

    public SynapseXPath getRequestXPath() {
        return this.requestXPath.get();
    }

    public SynapseXPath getTargetXPath() {
        return this.targetXPath.get();
    }

    public String getTargetKey() {
        return this.targetKey.get();
    }
}

